use Test::More 'no_plan';

#
# Test script for the winetest program
# Run the test as "winetest test.pl"
#

use wine;

$wine::debug = 0;

################################################################
# Declarations for functions we use in this script

wine::declare( "kernel32",
               SetLastError       => "void",
               GetLastError       => "int",
               GlobalAddAtomA     => "word",
               GlobalGetAtomNameA => "int",
               GetCurrentThread   => "int",
               GetExitCodeThread  => "int",
               GetModuleHandleA   => "int",
               GetProcAddress     => "int",
               lstrcatA           => "ptr"
);

################################################################
# Test some simple function calls

# Test string arguments
$atom = GlobalAddAtomA("foo");
ok( $atom >= 0xc000 && $atom <= 0xffff, "Valid atom handle" );
ok( !defined($wine::err), "No error code defined" );

# Test integer and string reference arguments
$buffer = "xxxxxx";
$ret = GlobalGetAtomNameA( $atom, \$buffer, length(buffer) );
ok( !defined($wine::err) );
is( 3, $ret, "Succeed code" );
is( "foo\000xx", lc $buffer, "Atom name" );

# Test integer reference
$code = 0;
$ret = GetExitCodeThread( GetCurrentThread(), \$code );
ok( !defined($wine::err) );
ok( $ret );
is(  0x103, $code );

# Test string return value
$str = lstrcatA( "foo\0foo", "bar" );
ok( !defined($wine::err) );
is( "foobar", $str );

################################################################
# Test last error handling

SetLastError( 123 );
$ret = GetLastError();
is( 123, $ret );

################################################################
# Test various error cases

eval { SetLastError(1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7); };
ok( $@ =~ /Too many arguments at/ );

my $funcptr = GetProcAddress( GetModuleHandleA("kernel32"), "SetLastError" );
ok( $funcptr );
eval { wine::call_wine_API( $funcptr, 10, $wine::debug, 0); };
ok( $@ =~ /Bad return type 10 at/ );

eval { foobar(1,2,3); };
ok( $@ =~ /Function 'foobar' not declared at/ );

