#include <windows.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <fstream>

#include "resource.h"

using namespace std;

UINT CALLBACK dlgProc(HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam){

	WCHAR str[] = {'T', 'e', 's', 't', '\0'};
	
	printf("Message: 0x%08x (%d)\n", uiMsg, uiMsg);

	switch(uiMsg){
	case WM_INITDIALOG:
		printf("WM INITDIALOG\n");
		// Set the text of the Group upon WM_INITDIALOG, this will result in a WM_CTLCOLORSTATIC 
		// notification under wine, but not in windows.
		SendDlgItemMessage(hdlg,IDC_GROUP,WM_SETTEXT,0,(LPARAM)str);
		break;
	case WM_CLOSE:
		::EndDialog(hdlg, IDOK);
		return TRUE;
  }
	return 0;
}

int main(int argc, char *argv)
{
	HMODULE hModule = ::GetModuleHandle(0);
	HINSTANCE hInst = hModule;

	HRSRC hrsrc = ::FindResource(hModule, 
                  MAKEINTRESOURCE(IDD_DIALOG), RT_DIALOG);

	HGLOBAL hglobal = ::LoadResource(hModule, hrsrc);

	// Redirect stdout/stderr to text file
	FILE *fp;
	fp = fopen("stdout.txt", "w");
	*stdout = *fp;
	fp = fopen("stderr.txt", "w");
	*stderr = *fp;
	ios::sync_with_stdio();

	::DialogBoxIndirectParam(hInst, 
                  (LPCDLGTEMPLATE) hglobal, 0, (DLGPROC)dlgProc, 0);


	return 0;
}