#!/bin/sh
# GIT-Updater by Christian Lachner alias Gladiac
# v0.4 - heavily customized for wine
# NOTE: I love wine ;)

function internal_config {
# SET ENABLE="yes" IF YOU ARE READY
ENABLE="yes";

# General Options
APP="WINE";
GITROOT="http://source.winehq.org/git/wine.git";
SRC="/usr/src";
TARGET="wine-git";
LOG="/var/log/getwinegit.sh."$APP".log";
PIDFILE="/tmp/getwinegit.sh."$APP".pid";
COMPILED_HELPER=$SRC"/"$TARGET"/getwinegit.sh_compiled"; # The name of a helperfile which helps mode 4 to detect, if the source has already been compiled or not
WAIT_FOR_CLEAN=5; # 0 = disabled
#DEFAULT_MODE="2"; # Enable this if don't you want to set the '-2'-Param everytime; works with mode 0, 1, 3 and 4 too ;)

# Compiler-Commands
CONFIGURE="./configure"; # CONFIGURE="./configure --prefix=PREFIX";
DEPEND="make depend";
COMPILE="make all";
INSTALL="make install";
UNINSTALL="make uninstall";
#ADDITIONAL="make programs";

# Colors - Disable them by adding a "#" at the begin of the lines
BLACK="0;30";	DGRAY="1;30";
BLUE="0;34";	LBLUE="1;34";
GREEN="0;32";	LGREEN="1;32";
CYAN="0;36";	LCYAN="1;36";
RED="0;31";		LRED="1;31";
PURPLE="0;35";	LPURPLE="1;35";
BROWN="0;33";	YELLOW="1;33";
LGRAY="0;37";	WHITE="1;37";

OK_COLOR=$LGREEN;
MODE_COLOR=$LBLUE;
ERROR_COLOR=$LRED;
INFO_COLOR=$YELLOW;
}

if [ "$( echo "x"$2 )" != "x" ]; then
	if [ -f "$2" ]; then
		. $2;
	else
		echo "Config-File \""$2"\" _NOT_ found! -> exiting!";
		exit 1;
	fi
else
	internal_config;
fi

function quit {
rm $PIDFILE &> /dev/null;
if [ $1 ]; then
	if [ $1 == "trap" ]; then
		echo;
		echo -e $(basename "$0")": \033["$INFO_COLOR"mstopped!\033[0m"; echo "<"$(basename "$0")"_killed />" >> $LOG; echo >> $LOG; echo $APP" End of Logfile" >> $LOG; date >> $LOG; echo >> $LOG;
		exit 0;
	fi
	if [ $1 != 0 ]; then
		echo >> $LOG; echo $(basename "$0")" exits with an error!" >> $LOG; echo $APP" End of Logfile" >> $LOG; date >> $LOG; echo >> $LOG;
		exit $1;
	fi
fi
echo;
echo -e $(basename "$0")": \033["$OK_COLOR"mdone!\033[0m"; echo >> $LOG; echo $APP" End of Logfile" >> $LOG; date >> $LOG; echo >> $LOG;
exit 0;
}

trap "quit trap" SIGINT;

function usage {
echo -e "Usage: \033["$LGREEN"m"$(basename "$0")"\033[0m \033["$MODE_COLOR"mmode\033[0m \033["$YELLOW"m[config-file]\033[0m";

echo;
echo "modes:";
echo -e " \033["$MODE_COLOR"m-0\033[0m   update the local source-tree";
echo -e " \033["$MODE_COLOR"m-1\033[0m   + compile the source";
echo -e " \033["$MODE_COLOR"m-2\033[0m   + install";
echo;
echo -e " \033["$MODE_COLOR"m-3\033[0m   no update; just compile the local source-tree and install";
echo -e " \033["$MODE_COLOR"m-4\033[0m   no update, no compile; just install";
echo;
echo -e " \033["$MODE_COLOR"m-h\033[0m   displays this help ;)";
echo;
echo -e "WARNING: Mode \033["$MODE_COLOR"m0-3\033[0m clean the source and disable mode \033["$MODE_COLOR"m4\033[0m!";
echo;
echo -e "Report bugs to \033["$INFO_COLOR"mgladiac@gmail.com\033[0m";
}

function create_log {
	echo -n "Creating Logfile \""$LOG"\"... "; rm $LOG &> /dev/null; touch $LOG; chmod 644 $LOG > /dev/null;
	if [ $? != 0 ]; then
		echo -e "\033["$INFO_COLOR"merror.\033[0m";
		echo "Could not create Logfile; Check Permissions and so on!"; exit 1;
#		echo -n "Disabling logging... "; LOG="/dev/null"; echo -e "\033["$OK_COLOR"mdone.\033[0m";
	else
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo -n "Writing Headers to Logfile... "; echo $APP" "$(basename "$0")"-Logfile" >> $LOG; date >> $LOG; echo $(basename "$0")" running in mode: "$MODE >> $LOG; echo "Parameters: "$* >> $LOG; echo >> $LOG;
		if [ $? != 0 ]; then
			echo -e "\033["$INFO_COLOR"merror.\033[0m";
			echo -e "Could not write Headers; Check Permissions and so on!"; exit 1;
#			echo -n "Disabling logging... "; LOG="/dev/null"; echo -e "\033["$OK_COLOR"mdone.\033[0m";
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi
	fi
}

function check_program { # name,check_command		check_command must return true ;)
	echo -n $1"... " >> $LOG;
	echo -n "Checking for "$1"... ";
	if $2 2>> /dev/null >&2; then
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo "ok!" >> $LOG;
		return 0;
	else
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo "not found!" >> $LOG;
		echo -e $1"-Exec not found... is "$1" installed? -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
	fi
}

function rest {
if [ $1 ]; then
	counter=$1;
else
	counter=3;
fi

for i in $( seq 1 $counter ); do
	sleep 1;
	if [ $i == $counter ]; then
		echo -n -e "\033["$LRED"m"$i"!\033[0m ";
	else
		if [ $i == $( expr $counter - 1 ) -o $i == $( expr $counter - 2 ) ]; then
			echo -n -e "\033["$YELLOW"m"$i"\033[0m ";
		else
			echo -n $i" ";
		fi
	fi
done
echo;
}

function clean_rest {
if [ $1 ]; then
	counter=$1;
else
	counter=0; # 0 = disabled
fi


if [ $counter != 0 ]; then
	echo -e -n "Cleaning "$APP"-Tree in \033["$YELLOW"m"$counter" \033[0m";
	if [ $counter == 1 ]; then
		echo -e -n "second!";
	else
		echo -e -n "seconds!";
	fi
	echo -e " WARNING: This disables mode \033["$MODE_COLOR"m4\033[0m!";
	echo -n " -> Sleeping: "; rest $counter;
fi
}

function git_update {
	echo -n "Processing GIT-Update... "; echo "<GIT_PULL>" >> $LOG; 
	git pull 2>> $LOG >&2;
	if [ "$( cat $LOG | grep "fatal: Not a git repository: '.git'" )" == "fatal: Not a git repository: '.git'" ]; then
		return 1;
	else
		return 0;
	fi
}

if [ $USER != "root" ]; then
	echo -e "You are not root -> \033["$ERROR_COLOR"mexiting!\033[0m"; LOG="/dev/null"; quit 1;
fi

if [ $ENABLE != "yes" ]; then
	echo -e "The Script has not been enabled... Please configure "$(basename "$0")" with an Editor -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
fi

if  [ $DEFAULT_MODE ]; then
	MODE=$DEFAULT_MODE;
fi

if [ $1 ]; then
	case "$1" in
		-0 | 0)
			MODE=0;
			;;
		-1 | 1)
			MODE=1;
			;;
		-2 | 2)
			MODE=2;
			;;
		-3 | 3)
			MODE=3;
			;;
		-4 | 4)
			MODE=4;
			;;
		-h | --help)
			usage;
			exit 0;
			;;
		*)
			echo -e "Unknown Mode \"\033["$INFO_COLOR"m"$1"\033[0m\" entered...";
			echo;
			usage;
			exit 1;
			;;
	esac
else
	if [ "$( echo "x"$DEFAULT_MODE )" == "x" ]; then
		usage;
		exit 0;
	fi
fi

if [ -f $PIDFILE ]; then
	echo -e "PID-File (pid: "$(cat $PIDFILE)") \033["$ERROR_COLOR"mexists!\033[0m";
	echo -e "Check, if "$(basename "$0")" is already running. If it does not, remove \033["$INFO_COLOR"m"$PIDFILE"\033[0m!";
	echo "Maybe you killed "$(basename "$0")" the last time?";
	exit 1;
fi

touch $PIDFILE > /dev/null; chmod 644 $PIDFILE > /dev/null; echo $$ > $PIDFILE;
if [ $? != 0 ]; then
	echo -e "Could not create PID-File... -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
fi

case "$MODE" in
	0)
		echo -e $(basename "$0")": running in mode \033["$MODE_COLOR"m0\033[0m...";
		echo " -> only getting current git-tree!";
		create_log;
		echo "checking needed Programs..." >> $LOG;
		check_program "GIT" "git --version";
		;;
	1)
		echo -e $(basename "$0")": running in mode \033["$MODE_COLOR"m1\033[0m...";
		echo " -> getting current git-tree + compile!";
		create_log;
		echo "checking needed Programs..." >> $LOG;
		check_program "GIT" "git --version";
		check_program "MAKE" "make --version";
		check_program "GCC" "gcc --version";
		check_program "Bison" "bison --version";
		check_program "Flex" "flex --version";
		check_program "Fontforge" "fontforge --version";
		;;
	2)
		echo -e $(basename "$0")": running in mode \033["$MODE_COLOR"m2\033[0m...";
		echo " -> getting current git-tree + compile + install!";
		create_log;
		echo "checking needed Programs..." >> $LOG;
		check_program "GIT" "git --version";
		check_program "MAKE" "make --version";
		check_program "GCC" "gcc --version";
		check_program "Bison" "bison --version";
		check_program "Flex" "flex --version";
		check_program "Fontforge" "fontforge --version";
		;;
	3)
		echo -e $(basename "$0")": running in mode \033["$MODE_COLOR"m3\033[0m...";
		echo -e " -> just compile the current tree in \""$SRC"\"!";
		create_log;
		echo "checking needed Programs..." >> $LOG;
		check_program "MAKE" "make --version";
		check_program "GCC" "gcc --version";
		check_program "Bison" "bison --version";
		check_program "Flex" "flex --version";
		check_program "Fontforge" "fontforge --version";
		;;
	4)
		echo -e $(basename "$0")": running in mode \033["$MODE_COLOR"m4\033[0m...";
		echo -e " -> just installe the compiled source-tree in \""$SRC"\"!";
		create_log;
		echo "checking needed Programs..." >> $LOG;
		check_program "MAKE" "make --version";
		check_program "GCC" "gcc --version";
		;;
	*)
		if [ "$( echo "x"$DEFAULT_MODE )" != "x" ]; then
			if [ $1 ]; then
				echo -e "Something messed up here; _This_ should really not happen... -> \033["$ERROR_COLOR"mexiting!\033[0m";
			else
				echo -e "I don't know the Mode \"\033["$MODE_COLOR"m"$MODE"\033[0m\"! Check DEFAULT_MODE -> \033["$MODE_COLOR"mexiting!\033[0m";
			fi
		else
			if [ $1 ]; then
				echo -e "Something messed up here; _This_ should really not happen... -> \033["$ERROR_COLOR"mexiting!\033[0m";
			else
				echo "No Parameter entered...";
				echo;
				usage;
				quit 1;
			fi
		fi
		quit 1;
		;;
esac

echo >> $LOG;

echo "checking "$(basename "$0")" Variables..." >> $LOG;
echo -n "Checking Main Variables... ";

echo -n "\$APP... " >> $LOG;
if [ "$( echo "x"$APP )" != "x" ]; then
	echo $APP >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$APP is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;

fi

echo -n "\$GITROOT... " >> $LOG;
if [ "$( echo "x"$GITROOT )" != "x" ]; then
	echo $GITROOT >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$GITROOT is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;

fi

echo -n "\$SRC... " >> $LOG;
if [ "$( echo "x"$SRC )" != "x" ]; then
	if [ ! -d $SRC ]; then
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo $SRC" (not found!) -> fatal!" >> $LOG;
		echo -e "Directory \"$SRC\" not found -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
	else
		echo $SRC >> $LOG;
	fi
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$SRC is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
fi

echo -n "\$TARGET... " >> $LOG;
if [ "$( echo "x"$TARGET )" != "x" ]; then
	echo $TARGET >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$TARGET is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;

fi

echo -n "\$LOG... " >> $LOG;
if [ "$( echo "x"$LOG )" != "x" ]; then
	echo $LOG >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$LOG is not set -> \033["$INFO_COLOR"mnot fatal!\033[0m";
fi

echo -n "\$COMPILED_HELPER... " >> $LOG;
if [ "$( echo "x"$COMPILED_HELPER )" != "x" ]; then
	echo $COMPILED_HELPER >> $LOG;
else
	if [ $MODE -ge 2 ]; then
		echo "not set -> fatal for modes greater or equal 2!" >> $LOG;
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Variable \$COMPILED_HELPER is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
	else
		echo "not set -> but that's ok for mode 0 and 1. however you should fix this." >> $LOG;
		echo -e "\033["$INFO_COLOR"merror, but not fatal.\033[0m";
		echo -e "Variable \$COMPILED_HELPER is not set -> \033["$INFO_COLOR"mnot fatal!\033[0m";
	fi
fi

echo -n "\$WAIT_FOR_CLEAN... " >> $LOG;
if [ "$( echo "x"$WAIT_FOR_CLEAN )" != "x" ]; then
	echo $WAIT_FOR_CLEAN >> $LOG;
else
	echo "not set -> but that's ok!" >> $LOG;
	echo -e "\033["$INFO_COLOR"merror, but not fatal.\033[0m";
	echo -e "Variable \$WAIT_FOR_CLEAN is not set -> defaulting to \033["$INFO_COLOR"m5\033[0m.";
	WAIT_FOR_CLEAN=5;
fi

echo -n "\$DEFAULT_MODE... " >> $LOG;
if [ "$( echo "x"$DEFAULT_MODE )" != "x" ]; then
	echo $DEFAULT_MODE >> $LOG;
else
	echo "not set, but that's ok." >> $LOG;
fi

echo -e "\033["$OK_COLOR"mdone.\033[0m";
echo >> $LOG;

echo "checking Compiler Variables..." >> $LOG;
echo -n "Checking Compiler Variables... ";

echo -n "\$CONFIGURE... " >> $LOG;
if [ "$( echo "x"$CONFIGURE )" != "x" ]; then
	echo $CONFIGURE >> $LOG;
else
	if [ $MODE == 1 -o $MODE == 3 ]; then
		echo "not set, but that's ok for modes 1 and 3. however you should fix this." >> $LOG;
		echo -e "\033["$INFO_COLOR"merror, but not fatal.\033[0m";
		echo -e "Variable \$CONFIGURE is not set -> \033["$INFO_COLOR"mnot fatal!\033[0m";
	else
		echo "not set -> fatal!" >> $LOG;
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Variable \$CONFIGURE is not set -> \033["$ERROR_COLOR"mfatal!\033[0m"; quit 1;
	fi
fi

echo -n "\$DEPEND... " >> $LOG;
if [ "$( echo "x"$DEPEND )" != "x" ]; then
	echo $DEPEND >> $LOG;
else
	if [ $MODE == 1 -o $MODE == 3 ]; then
		echo "not set, but that's ok for modes 1 and 3. however you should fix this." >> $LOG;
		echo -e "\033["$INFO_COLOR"merror, but not fatal.\033[0m";
		echo -e "Variable \$DEPEND is not set -> \033["$INFO_COLOR"mnot fatal!\033[0m";
	else
		echo "not set -> fatal!" >> $LOG;
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Variable \$DEPEND is not set -> \033["$ERROR_COLOR"mfatal!\033[0m"; quit 1;
	fi
fi

echo -n "\$COMPILE... " >> $LOG;
if [ "$( echo "x"$COMPILE )" != "x" ]; then
	echo $COMPILE >> $LOG;
else
	if [ $MODE == 1 -o $MODE == 3 ]; then
		echo "not set, but that's ok for modes 1 and 3. however you should fix this." >> $LOG;
		echo -e "\033["$INFO_COLOR"merror, but not fatal.\033[0m";
		echo -e "Variable \$COMPILE is not set -> \033["$INFO_COLOR"mnot fatal!\033[0m";
	else
		echo "not set -> fatal!" >> $LOG;
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Variable \$COMPILE is not set -> \033["$ERROR_COLOR"mfatal!\033[0m"; quit 1;
	fi
fi

echo -n "\$INSTALL... " >> $LOG;
if [ "$( echo "x"$INSTALL )" != "x" ]; then
	echo $INSTALL >> $LOG;
else
	if [ $MODE == 1 -o $MODE == 3 ]; then
		echo "not set, but that's ok for modes 1 and 3. however you should fix this." >> $LOG;
		echo -e "\033["$INFO_COLOR"merror, but not fatal.\033[0m";
		echo -e "Variable \$INSTALL is not set -> \033["$INFO_COLOR"mnot fatal!\033[0m";
	else
		echo "not set -> fatal!" >> $LOG;
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Variable \$INSTALL is not set -> \033["$ERROR_COLOR"mfatal!\033[0m"; quit 1;
	fi
fi

echo -n "\$UNINSTALL... " >> $LOG;
if [ "$( echo "x"$UNINSTALL )" != "x" ]; then
	echo $UNINSTALL >> $LOG;
else
	if [ $MODE == 1 -o $MODE == 3 ]; then
		echo "not set, but that's ok for modes 1 and 3. however you should fix this." >> $LOG;
		echo -e "\033["$INFO_COLOR"merror, but not fatal.\033[0m";
		echo -e "Variable \$UNINSTALL is not set -> \033["$INFO_COLOR"mnot fatal!\033[0m";
	else
		echo "not set -> fatal!" >> $LOG;
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Variable \$UNINSTALL is not set -> \033["$ERROR_COLOR"mfatal!\033[0m"; quit 1;
	fi
fi

echo -n "\$ADDITIONAL... " >> $LOG;
if [ "$( echo "x"$ADDITIONAL )" != "x" ]; then
	echo $ADDITIONAL >> $LOG;
else
	echo "not set, but that's ok." >> $LOG;
fi

echo -e "\033["$OK_COLOR"mdone.\033[0m";
echo >> $LOG;

if [ $MODE -lt 3 ]; then
	echo -n "Changing to \""$SRC"\"... "; cd $SRC > /dev/null; echo -e "\033["$OK_COLOR"mdone.\033[0m";

	echo -n "Checking availability of "$APP"-tree in \""$SRC"\"... ";
	if [ -d $SRC"/"$TARGET ]; then 
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo -e "  Old "$APP"-tree found -> \033["$INFO_COLOR"mUpdate initiated!\033[0m";
		echo -n "Changing to \""$SRC"/"$TARGET"\"... "; cd $SRC/$TARGET; echo -e "\033["$OK_COLOR"mdone.\033[0m";
		if [ -f $COMPILED_HELPER ]; then
			clean_rest $WAIT_FOR_CLEAN;
		fi
		echo -n "Cleaning "$APP"-Tree... "; echo "<CLEAN_TREE>" >> $LOG; rm $COMPILED_HELPER &> /dev/null; make clean 2>> $LOG >&2; echo "</CLEAN_TREE>" >> $LOG; echo -e "\033["$OK_COLOR"mdone.\033[0m";


		git_update;

		if [ $? != 0 ]; then
			echo -e "\033["$ERROR_COLOR"merror! (not fatal)\033[0m";
			echo -e "  Update cancelled -> \033["$INFO_COLOR"mCheckout initiated!\033[0m";
			echo -n "Processing GIT-Checkout... "; echo "<GIT_CHECKOUT>" >> $LOG; git clone $GITROOT $TARGET 2>> $LOG >&2;
			if [ $? != 0 ]; then
				echo -e "\033["$ERROR_COLOR"merror!\033[0m"; echo "</GIT_CHECKOUT>" >> $LOG; echo;
				echo -e "Seems like your Internet-Connection is down! -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
			else
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
			fi
			echo "</GIT_CHECKOUT>" >> $LOG;
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";

			if [ "$( cat $LOG | grep "Already up-to-date." )" == "Already up-to-date." ]; then # dirty, but good :)
				echo -e "  Our local Source-Tree is already \033["$OK_COLOR"mup-to-date\033[0m. ;-)";
#				if [ $MODE -ge 1 ]; then
#					echo -e "No need to compile this again. If you still want to do so use \033["$MODE_COLOR"m-3\033[0m instead!";
#					quit 0;
#				fi
			fi
		fi
		echo "</GIT_PULL>" >> $LOG;
	else
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo -e "  Old "$APP"-tree _NOT_ found -> \033["$INFO_COLOR"mCheckout initiated!\033[0m";
		echo -n "Processing GIT-Checkout... "; echo "<GIT_CHECKOUT>" >> $LOG; git clone $GITROOT $TARGET 2>> $LOG >&2;
		if [ $? != 0 ]; then
			echo -e "\033["$ERROR_COLOR"merror!\033[0m"; echo "</GIT_CHECKOUT>" >> $LOG; echo;
			echo -e "Seems like your Internet-Connection is down! -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi
		echo "</GIT_CHECKOUT>" >> $LOG;
	fi
else
	echo -n "Checking availability of "$APP"-tree in \""$SRC"\"... ";
	if [ -d $SRC"/"$TARGET ]; then
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		if [ $MODE = 3 ]; then
			if [ -f $COMPILED_HELPER ]; then
				clean_rest $WAIT_FOR_CLEAN;
			fi
			echo -n "Cleaning "$APP"-Tree... "; echo "<CLEAN_TREE>" >> $LOG; rm $COMPILED_HELPER &> /dev/null; make clean 2>> $LOG >&2; echo "</CLEAN_TREE>" >> $LOG; echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi
	else
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "  Old "$APP"-tree _NOT_ found -> \033["$ERROR_COLOR"mexiting!\033[0m";
		case $MODE in
			3)
				echo "That's bad cause mode 3 wants to compile something ;)... use mode 0-2 instead or check \$SRC and \$TARGET."; quit 1;
				;;
			4)
				echo "That's bad cause mode 4 wants to install something ;)... use mode 2 instead or check \$SRC and \$TARGET."; quit 1;
				;;
		esac
	fi
fi

if [ $MODE -ge 1 ]; then
	echo -n "Changing to \""$SRC"/"$TARGET"\"... "; cd $SRC/$TARGET >> /dev/null;
	if [ $? != 0 ]; then
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Could not change to \""$SRC"/"$TARGET"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
	else
		echo -e "\033["$OK_COLOR"mdone.\033[0m";

		if [ $MODE != 4 ]; then
			echo -n "Creating Makefile... "; echo "<CONFIGURE: "$CONFIGURE">" >> $LOG; $CONFIGURE 2>> $LOG >&2;
			if [ $? != 0 ]; then
				echo -e "\033["$ERROR_COLOR"merror.\033[0m";
				echo -e "Something went wrong when executing \""$CONFIGURE"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
			else
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
			fi
			echo "</CONFIGURE>" >> $LOG;

			echo -n "Making Dependencies... "; echo "<DEPEND: "$DEPEND">" >> $LOG; $DEPEND 2>> $LOG >&2;
			if [ $? != 0 ]; then
				echo -e "\033["$ERROR_COLOR"merror.\033[0m";
				echo -e "Something went wrong when executing \""$DEPEND"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
			else
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
			fi
			echo "</DEPEND>" >> $LOG;

			echo -n "Compiling... "; echo "<COMPILE: "$COMPILE">" >> $LOG; $COMPILE 2>> $LOG >&2;
			if [ $? != 0 ]; then
				echo -e "\033["$ERROR_COLOR"merror.\033[0m";
				echo -e "Something went wrong when executing \""$COMPILE"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
				rm $COMPILED_HELPER &> /dev/null;
			else
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
				touch $COMPILED_HELPER;
			fi
			echo "</COMPILE>" >> $LOG;

#			echo -n "Compiling additional Stuff... "; echo "<ADDITIONAL: "$ADDITIONAL">" >> $LOG; $ADDITIONAL 2>> $LOG >&2;
#			if [ $? != 0 ]; then
#				echo -e "\033["$ERROR_COLOR"merror.\033[0m";
#				echo -e "Something went wrong when executing \""$ADDITIONAL"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
#			else
#				echo -e "\033["$OK_COLOR"mdone.\033[0m";
#			fi
#			echo "</ADDITIONAL>" >> $LOG;
		fi

		if [ $MODE -ge 2 ]; then
			echo -n "Checking Compilation... ";
			if [ -f $COMPILED_HELPER ]; then
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
				echo -n "Removing old "$APP"-Installation... "; echo "<UNINSTALL: "$UNINSTALL">" >> $LOG; $UNINSTALL 2>> $LOG >&2;
				if [ $? != 0 ]; then
					echo -e "\033["$ERROR_COLOR"merror.\033[0m";
					echo -e "Something went wrong when executing \""$UNINSTALL"\" -> \033["$INFO_COLOR"merror, but not fatal!\033[0m";	# not fatal
					if [ $MODE = 4 ]; then
						echo "OK, this looks like sh*t... let's see, what the next step does...";
					fi
				else
					echo -e "\033["$OK_COLOR"mdone.\033[0m";
				fi
				echo "</UNINSTALL>" >> $LOG;

				echo -n "Installing... "; echo "<INSTALL: "$INSTALL">" >> $LOG; $INSTALL 2>> $LOG >&2;
				if [ $? != 0 ]; then
					echo -e "\033["$ERROR_COLOR"merror.\033[0m";
					echo -e "Something went wrong when executing \""$INSTALL"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; quit 1;
					if [ $MODE = 4 ]; then
						echo -e "You're in Mode 4. This could mean that you did not compile the source. Use Mode 3 instead.";
					fi
				else
					echo -e "\033["$OK_COLOR"mdone.\033[0m";
				fi
			else
				echo -e "\033["$ERROR_COLOR"merror.\033[0m";
				echo -e "It seems that the source has not been compiled yet. Use mode \033["$MODE_COLOR"m3\033[0m instead.";
				quit 1;
			fi
			echo "</INSTALL>" >> $LOG;
		fi
	fi
fi

quit;

