/*
 * Copyright (C) 2005 Vijay Kiran Kamuju
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdarg.h>
#include "windef.h"
#include "winbase.h"
#include "winuser.h"
#include "winreg.h"
#include "ole2.h"
#include "msxml.h"
#include "uuids.h"
#include "wine/debug.h"

WINE_DEFAULT_DEBUG_CHANNEL(msxml);

HRESULT XMLDocument_create(IUnknown *pUnkOuter, LPVOID *ppObj);

typedef struct {
    IXMLDocument lpVtbl;
    ULONG ref;
} IXMLDocumentImpl;

static struct IXMLDocumentVtbl IXMLDoc_Vtbl;

static HRESULT WINAPI IXMLDocument_QueryInterface(IXMLDocument *iface, REFIID riid, void** ppvObject)
{
    IXMLDocumentImpl *This = (IXMLDocumentImpl *)iface;

    FIXME("(%p/%p)->(%s,%p)\n", iface, This, debugstr_guid(riid), ppvObject);

    if (IsEqualGUID(riid, &IID_IUnknown)
        || IsEqualGUID( riid, &IID_IDispatch)
        || IsEqualGUID( riid, &IID_IPersistStream)
        || IsEqualGUID( riid, &IID_IXMLDocument))
    {
      IClassFactory_AddRef(iface);
      *ppvObject = This;
      return S_OK;
    }

    ERR("(%p)->(%s,%p),not found\n",This,debugstr_guid(riid),ppvObject);
    return E_NOINTERFACE;
}

static ULONG WINAPI IXMLDocument_AddRef(IXMLDocument *iface)
{
    IXMLDocumentImpl *This = (IXMLDocumentImpl *)iface;

    TRACE("(%p)\n", iface);
    return InterlockedIncrement(&This->ref);
}

static ULONG WINAPI IXMLDocument_Release(IXMLDocument *iface)
{
   IXMLDocumentImpl *This = (IXMLDocumentImpl *)iface;
   ULONG ref = InterlockedDecrement(&This->ref);

   TRACE("(%p)\n", iface);
   if (!ref)
       HeapFree(GetProcessHeap(), 0, This);

   return ref;
}

static HRESULT WINAPI IXMLDocument_GetTypeInfoCount(IXMLDocument *iface, UINT *pctinfo)
{
    FIXME("(%p)->(%p)\n", iface, pctinfo);
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_GetTypeInfo(IXMLDocument *iface, UINT iTInfo,
                                               LCID lcid, ITypeInfo **ppTInfo)
{
    FIXME("(%p)->(%u %lu %p)\n", iface, iTInfo, lcid, ppTInfo);
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_GetIDsOfNames(IXMLDocument *iface, REFIID riid,
                                                 LPOLESTR *rgszNames, UINT cNames,
                                                 LCID lcid, DISPID *rgDispId)
{
    FIXME("(%p)->(%s %p %u %lu %p)\n", iface, debugstr_guid(riid), rgszNames, cNames,
                                       lcid, rgDispId);
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_Invoke(IXMLDocument *iface, DISPID dispIdMember,
                                          REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS *pDispParams,
                                          VARIANT *pVarResult, EXCEPINFO *pExcepInfo, UINT *puArgErr)
{
    FIXME("(%p)->(%ld %s %ld %d %p %p %p %p)\n", iface, dispIdMember, debugstr_guid(riid),
                                                 lcid, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);

    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_root(IXMLDocument *iface, IXMLElement** iElement)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_fileSize(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}


static HRESULT WINAPI IXMLDocument_get_fileModifiedDate(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_fileUpdatedDate(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_URL(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_put_URL(IXMLDocument *iface, BSTR p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_mimeType(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_readyState(IXMLDocument *iface, long *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_charset(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_put_charset(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_version(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_doctype(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_get_dtdURl(IXMLDocument *iface, BSTR *p)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static HRESULT WINAPI IXMLDocument_createElement(IXMLDocument *iface, VARIANT vType,
                                                 VARIANT var1, IXMLElement** ppElem)
{
    FIXME("\n");
    return E_NOTIMPL;
}

static IXMLDocumentVtbl IXMLDoc_Vtbl =
{
    IXMLDocument_QueryInterface,
    IXMLDocument_AddRef,
    IXMLDocument_Release,
    IXMLDocument_GetTypeInfoCount,
    IXMLDocument_GetTypeInfo,
    IXMLDocument_GetIDsOfNames,
    IXMLDocument_Invoke,
    IXMLDocument_get_root,
    IXMLDocument_get_fileSize,
    IXMLDocument_get_fileModifiedDate,
    IXMLDocument_get_fileUpdatedDate,
    IXMLDocument_get_URL,
    IXMLDocument_put_URL,
    IXMLDocument_get_mimeType,
    IXMLDocument_get_readyState,
    IXMLDocument_get_charset,
    IXMLDocument_put_charset,
    IXMLDocument_get_version,
    IXMLDocument_get_doctype,
    IXMLDocument_get_dtdURl,
    IXMLDocument_createElement
};
