<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY walsh-style PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA DSSSL>
<!ENTITY cygnus-style SYSTEM "/usr/lib/sgml/stylesheet/dsssl/docbook/cygnus/cygnus-both.dsl" CDATA DSSSL>
]>

<style-sheet>
<style-specification id="html" use="docbook">
<style-specification-body>

(define %html-pubid% "-//W3C//DTD HTML 4.01 Transitional//EN")
(define %html-header-tags% '(("META" ("HTTP-EQUIV" "Content-Type") ("CONTENT" "text/html; charset=ISO-8859-1"))))
(define %use-id-as-filename% #t)
(define %html-ext% ".html")

(define %stylesheet% "faq.css")
(define %stylesheet-type% "text/css")

<!-- We need article and article-title-page so we don't create a DIV for the title -->
(element article
  (let* ((info (node-list-filter-by-gi (children (current-node))
				       (list (normalize "artheader")
					     (normalize "articleinfo"))))
	 (ititle (select-elements (children info) (normalize "title")))
	 (title (if (node-list-empty? ititle)
		    (select-elements (children (current-node)) 
				     (normalize "title"))
		    (node-list-first ititle)))
	 (tsosofo (with-mode head-title-mode
		    (process-node-list title)))
	 (nl   (titlepage-info-elements (current-node) info)))
    (html-document
     tsosofo
     (make sequence
	   (if %generate-article-titlepage%
	       (make sequence
		 (article-titlepage nl 'recto)
		 (article-titlepage nl 'verso))
	       ($component-title$))

	   (if (not (generate-toc-in-front))
	       (process-children)
	       (empty-sosofo))
	  
	   (if %generate-article-toc%
	       (make sequence
		 (build-toc (current-node)
			    (toc-depth (current-node))))
	       (empty-sosofo))
	  
	   (let loop ((gilist ($generate-article-lot-list$)))
	     (if (null? gilist)
		 (empty-sosofo)
		 (if (not (node-list-empty?
			   (select-elements (descendants (current-node))
					    (car gilist))))
                          (make sequence
			    (build-lot (current-node) (car gilist))
			    (loop (cdr gilist)))
                          (loop (cdr gilist)))))

	   (if (generate-toc-in-front)
	       (process-children)
	       (empty-sosofo))))))

(define (article-titlepage elements #!optional (side 'recto))
  (let ((nodelist (titlepage-nodelist 
		   (if (equal? side 'recto)
		       (article-titlepage-recto-elements)
		       (article-titlepage-verso-elements))
		   elements)))
    (if (article-titlepage-content? elements side)
        (make sequence
	  (let loop ((nl nodelist) (lastnode (empty-node-list)))
	    (if (node-list-empty? nl)
		(empty-sosofo)
		(make sequence
		  (if (or (node-list-empty? lastnode)
			  (not (equal? (gi (node-list-first nl))
				       (gi lastnode))))
		      (article-titlepage-before (node-list-first nl) side)
		      (empty-sosofo))
		  (cond
		   ((equal? (gi (node-list-first nl)) (normalize "abbrev"))
		    (article-titlepage-abbrev (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "abstract"))
		    (article-titlepage-abstract (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "address"))
		    (article-titlepage-address (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "affiliation"))
		    (article-titlepage-affiliation (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "artpagenums"))
		    (article-titlepage-artpagenums (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "author"))
		    (article-titlepage-author (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "authorblurb"))
		    (article-titlepage-authorblurb (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "authorgroup"))
		    (article-titlepage-authorgroup (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "authorinitials"))
		    (article-titlepage-authorinitials (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "bibliomisc"))
		    (article-titlepage-bibliomisc (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "biblioset"))
		    (article-titlepage-biblioset (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "bookbiblio"))
		    (article-titlepage-bookbiblio (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "citetitle"))
		    (article-titlepage-citetitle (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "collab"))
		    (article-titlepage-collab (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "confgroup"))
		    (article-titlepage-confgroup (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "contractnum"))
		    (article-titlepage-contractnum (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "contractsponsor"))
		    (article-titlepage-contractsponsor (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "contrib"))
		    (article-titlepage-contrib (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "copyright"))
		    (article-titlepage-recto-copyright (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "corpauthor"))
		    (article-titlepage-corpauthor (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "corpname"))
		    (article-titlepage-corpname (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "date"))
		    (article-titlepage-date (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "edition"))
		    (article-titlepage-edition (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "editor"))
		    (article-titlepage-editor (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "firstname"))
		    (article-titlepage-firstname (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "graphic"))
		    (article-titlepage-graphic (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "honorific"))
		    (article-titlepage-honorific (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "indexterm"))
		    (article-titlepage-indexterm (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "invpartnumber"))
		    (article-titlepage-invpartnumber (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "isbn"))
		    (article-titlepage-isbn (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "issn"))
		    (article-titlepage-issn (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "issuenum"))
		    (article-titlepage-issuenum (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "itermset"))
		    (article-titlepage-itermset (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "keywordset"))
		    (article-titlepage-keywordset (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "legalnotice"))
		    (article-titlepage-recto-legalnotice (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "lineage"))
		    (article-titlepage-lineage (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "mediaobject"))
		    (article-titlepage-mediaobject (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "modespec"))
		    (article-titlepage-modespec (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "orgname"))
		    (article-titlepage-orgname (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "othercredit"))
		    (article-titlepage-othercredit (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "othername"))
		    (article-titlepage-othername (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "pagenums"))
		    (article-titlepage-pagenums (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "printhistory"))
		    (article-titlepage-printhistory (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "productname"))
		    (article-titlepage-productname (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "productnumber"))
		    (article-titlepage-productnumber (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "pubdate"))
		    (article-titlepage-pubdate (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "publisher"))
		    (article-titlepage-publisher (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "publishername"))
		    (article-titlepage-publishername (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "pubsnumber"))
		    (article-titlepage-pubsnumber (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "releaseinfo"))
		    (article-titlepage-releaseinfo (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "revhistory"))
		    (article-titlepage-revhistory (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "seriesinfo"))
		    (article-titlepage-seriesinfo (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "seriesvolnums"))
		    (article-titlepage-seriesvolnums (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "subjectset"))
		    (article-titlepage-subjectset (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "subtitle"))
		    (article-titlepage-subtitle (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "surname"))
		    (article-titlepage-surname (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "title"))
		    (article-titlepage-title (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "titleabbrev"))
		    (article-titlepage-titleabbrev (node-list-first nl) side))
		   ((equal? (gi (node-list-first nl)) (normalize "volumenum"))
		    (article-titlepage-volumenum (node-list-first nl) side))
		   (else
		    (article-titlepage-default (node-list-first nl) side)))
		  (loop (node-list-rest nl) (node-list-first nl)))))
	  (article-titlepage-separator side))
	(empty-sosofo))))

<!-- We need article-titlepage-separator so it can be empty -->
(define (article-titlepage-separator side)
  (empty-sosofo))

<!-- We need mode article-titlepage-recto-mode/title for the anchor TOP -->
(mode article-titlepage-recto-mode
  (element title 
    (make element gi: "H1"
      attributes: (list
        (list
          "CLASS"
          (gi)))
      (make sequence
        (make element gi: "A"
          attributes: '(("NAME" "TOP"))
          (literal
            ""))
        (with-mode
          title-mode
          (process-children-trim))))))

<!-- We need qandaset so we don't create a DIV for the body -->
(element qandaset
  (let ((title (select-elements (children (current-node)) 
                                (normalize "title")))
        ;; process title and rest separately so that we can put the TOC
        ;; in the rigth place...
        (rest  (node-list-filter-by-not-gi (children (current-node))
                                           (list (normalize "title")))))
    (make sequence
      (process-node-list
        title)
      (if
        ($generate-qandaset-toc$)
        (process-qanda-toc)
        (empty-sosofo))
      (process-node-list
        rest))))

<!-- We need qandaset title so H1 is used -->
(element (qandaset title)
  (make element gi: "H1"
    attributes: (list
      (list
        "CLASS"
        (gi
          (current-node))))
    (process-children)))

<!-- We need qandadiv so we have a ruler before, no DIV, and a link to the top after -->
(element qandadiv
  (make sequence
    (make empty-element gi: "HR"
      attributes: '(("SIZE" "3")))
    (process-children)
    (make element gi: "A"
        attributes: '(("HREF" "#TOP"))
        (literal
          "Back to top"))))

<!-- We need qandadiv title so H2 is used -->
(element (qandadiv title)
  (make element gi: "H2"
    (make element gi: "A"
      attributes: (list
        (list
          "NAME"
          (element-id
            (parent
              (current-node)))))
      (literal
        ""))
    (process-children)))

<!-- We need qandaentry so we don't create a DIV for the question -->
(element qandaentry
  (make sequence
    (process-children)))

<!-- We need question so H3 is used, no DIV and no automatic docbook numbering -->
(element question
  (let* ((chlist   (children (current-node)))
         (firstch  (node-list-first chlist))
         (restch   (node-list-rest chlist)))
    (make sequence
      (make element gi: "H3" 
        (make element gi: "A"
          attributes: (list
            (list
              "NAME"
              (element-id)))
          (empty-sosofo))
        (make element gi: "B"
          (process-node-list
            (children
              firstch))))
      (process-node-list restch))))

<!-- We need answer so no DIV -->
(element answer
  (let* ((inhlabel (inherited-attribute-string (normalize "defaultlabel")))
         (deflabel (if inhlabel inhlabel (qanda-defaultlabel)))
         (label    (attribute-string (normalize "label")))
         (chlist   (children (current-node)))
         (firstch  (node-list-first chlist))
         (restch   (node-list-rest chlist)))
    (make sequence
      (make element gi: "P"
        (make element gi: "B"
          (literal
            (question-answer-label
              (current-node))
            " "))
        (process-node-list
          (children
            firstch)))
    (process-node-list
      restch))))

<!-- We need process-qanda-toc so the toc is made with OL and LI rather than DL, DT and DD -->
(define (process-qanda-toc #!optional (node (current-node)))
  (let* ((divs     (node-list-filter-by-gi (children node)
                                           (list (normalize "qandadiv"))))
         (entries  (node-list-filter-by-gi (children node)
                                           (list (normalize "qandaentry"))))
         (inhlabel (inherited-attribute-string (normalize "defaultlabel")))
         (deflabel (if inhlabel inhlabel (qanda-defaultlabel))))
    (make element gi: "OL"
      attributes:
        (if
          (node-list-empty?
            divs)
          '(("CLASS" "arabic"))
          '(("CLASS" "upper")))
      (with-mode
        qandatoc
        (process-node-list
          divs))
      (with-mode
        qandatoc
        (process-node-list
          entries)))))

<!-- We need mode qandatoc/qandadiv so the toc is made with OL and LI rather than DL, DT and DD -->
<!-- We need mode qandatoc/qandadiv title so there's no automatic docbook numbering -->
<!-- We need mode qandatoc/question so the toc is made with OL and LI rather than DL, DT and DD, H3 is used and there's no automatic docbook numbering -->
(mode qandatoc
  (element qandadiv
    (let ((title (select-elements (children (current-node))
                                  (normalize "title"))))
      (make sequence
        (make element gi: "LI"
          (process-node-list
            title)
          (process-qanda-toc)))))
  (element (qandadiv title)
    (make sequence
      (make element gi: "A"
        attributes: (list
          (list
            "HREF"
            (href-to
              (parent
                (current-node)))))
        (process-children))))
  (element question
    (let* ((chlist   (children (current-node)))
           (firstch  (node-list-first chlist)))
      (make element gi: "LI"
        (make element gi: "A"
          attributes: (list
            (list
              "HREF"
              (href-to
                (current-node))))
          (process-node-list
            (children
              firstch)))))))

</style-specification-body>
</style-specification>

<external-specification id="docbook" document="walsh-style">

</style-sheet>
