
TOPSRCDIR             = ..
TOPOBJDIR             = ..
SRCDIR                = ..

prefix          = /home/NeoWine/wine
exec_prefix     = ${prefix}
bindir          = ${exec_prefix}/programs
libdir          = ${prefix}/lib
infodir         = ${prefix}/info
mandir          = ${prefix}/man
dlldir          = ${prefix}/dlls

# Some useful definitions
SHELL     = /bin/sh
CC        = gcc
CPP       = gcc -E
CXX       = c++
WRC       = $(prefix)/tools/wrc/wrc

# DEBUG_FLG =
DEBUG_FLG = -g

CFLAGS    = $(DEBUG_FLG) $(CEXTRA)
CXXFLAGS  = $(DEBUG_FLG) $(CXXEXTRA)
WRCFLAGS  = $(WRCEXTRA)
OPTIONS   =  -D_REENTRANT
DIVINCL   = -I$(SRCDIR) $(INCLUDE_PATH) $(WINE_INCLUDE_PATH)
ALLCFLAGS = $(DIVINCL) $(CFLAGS) $(GLOBAL_DEFINES) $(DEFINES) $(OPTIONS)
ALLCXXFLAGS=$(DIVINCL) $(CXXFLAGS) $(GLOBAL_DEFINES) $(DEFINES) $(OPTIONS)
LDDLLFLAGS= -Wl,-Bsymbolic,-z,defs,-init,__wine_spec_init,-fini,__wine_spec_fini
STRIP     = strip
STRIPFLAGS= --strip-unneeded
LN_S      = ln -s
RM        = rm -f
MV        = mv
MKDIR     = mkdir -p
WINE      = $(prefix)/wine
WINEBUILD = $(prefix)/tools/winebuild/winebuild
mk_s_lib = ar -rs
LDSHARED  = $(CC) -shared
LDXXSHARED= $(CXX) -shared

# Installation infos
INSTALL         = install
INSTALL_PROGRAM = $(INSTALL)
INSTALL_SCRIPT  = $(INSTALL)
INSTALL_DATA    = $(INSTALL) -m 644

### Generic autoconf targets
# Implicit rules
.SUFFIXES:  .spec .c .cxx .cpp .rc .res

.c.o:
	$(CC) -c $(ALLCFLAGS) -o $@ $<

.cpp.o:
	$(CXX) -c $(ALLCXXFLAGS) -o $@ $<

.cxx.o:
	$(CXX) -c $(ALLCXXFLAGS) -o $@ $<

.rc.res:
	$(LDPATH) $(WRC) $(WRCFLAGS) $(DIVINCL) -o $@ $<

# make dependencies rules
.cpp.d:
	$(CPP) -MM -D__stdcall -DRC_INVOKED $(ALLCXXFLAGS) -o $@ $< -MT $(HERE_MAKE)$(@:.d=.o)

.cxx.d:
	$(CPP) -MM -D__stdcall -DRC_INVOKED $(ALLCXXFLAGS) -o $@ $< -MT $(HERE_MAKE)$(@:.d=.o)



all: $(SUBDIRS) $(LIBS:%=lib%.a) $(DLLS:%=%.so) $(EXES:%=%.so)

# Installation infos
OBJS            = $(foo_dll_OBJS) $(foo_exe_OBJS) $(foo_lib_OBJS) \
                  $(SPEC_SRCS:.spec=.spec.o)
CLEAN_FILES     = *.spec.c y.tab.c y.tab.h lex.yy.c \
                  core *.orig *.rej \
                  \\\#*\\\# *~ *% .\\\#*
DISTCLEAN_FILES = config.* Makefile Make.rules

.PHONY: all install uninstall clean distclean depend dummy

# Rules for cleaning

$(SUBDIRS:%=%/__clean__): dummy
	cd `dirname $@` && $(MAKE) clean

$(EXTRASUBDIRS:%=%/__clean__): dummy
	-cd `dirname $@` && $(RM) $(CLEAN_FILES)

clean:: $(SUBDIRS:%=%/__clean__) $(EXTRASUBDIRS:%=%/__clean__)
	$(RM) $(CLEAN_FILES) $(RC_SRCS:.rc=.res) $(OBJS) $(EXES:%.exe=%) $(EXES:%=%.so) $(EXES:%=%.spec.o) $(DLLS:%=%.so) $(DLLS:%=%.spec.o)

# Rule for distcleaning

distclean: clean
	$(RM) $(DISTCLEAN_FILES)

# Rules for installing

$(SUBDIRS:%=%/__install__): dummy
	cd `dirname $@` && $(MAKE) install

$(SUBDIRS:%=%/__uninstall__): dummy
	cd `dirname $@` && $(MAKE) uninstall

# Misc. rules

$(SUBDIRS): dummy
	@cd $@ && $(MAKE)

dummy:

# End of global rules

install::
	_list="$(SUBDIRS)"; for i in $$_list; do (cd $$i; $(MAKE) install) || exit 1; done
	_list="$(EXES:%.exe=%)"; for i in $$_list; do $(INSTALL_SCRIPT) $$i $(bindir); done
	_list="$(EXES:%=%.so) $(DLLS:%=%.so)"; for i in $$_list; do $(INSTALL_PROGRAM) $$i $(dlldir); done

uninstall::
	_list="$(SUBDIRS)"; for i in $$_list; do (cd $$i; $(MAKE) uninstall) || exit 1; done
	_list="$(EXES:%.exe=%)"; for i in $$_list; do $(RM) $(bindir)/$$i;done
	_list="$(EXES:%=%.so) $(DLLS:%=%.so)"; for i in $$_list; do $(RM) $(dlldir)/$$i;done

clean::
	$(RM) wineapploader $(EXES:%.exe=%)

