wine_root = /home/NeoWine/wine
wine_include = $(wine_root)/include
Demo_root = /home/NeoWine/Demo
msvc_root = /home/NeoWine/msvc
stlport_root    = /home/NeoWine/STLport

# Wine
WINE_INCLUDE_PATH = -I$(wine_include)

WINE_LIBRARY_ROOT = $(wine_root)/libs
WINE_LIBRARIES_PATH = -L$(WINE_LIBRARY_ROOT) -L$(wine_root)/dlls -L.
WINE_LIBRARIES = -lwine -lwine_unicode -luuid
GCC_LIBS      = -lm

WINE_DLL_PATH     = -L$(wine_root)/dlls
WINE_DLLS = advapi32 \
			comdlg32 \
			comctl32 \
			gdi32 \
			kernel32 \
			odbc32 \
			ole32 \
			oleaut32 \
			shell32 \
			user32 \
			winspool \
			wsock32 \
			ws2_32 \
			msvfw32 \
			wininet \
			oledlg \
			rasapi32 \
			winmm \
			urlmon \
			shlwapi \
			imagehlp \
			msvcrt


LDPATH            = LD_LIBRARY_PATH="$(WINE_LIBRARY_ROOT):$$LD_LIBRARY_PATH"

### Common settings
CEXTRA       = -fpermissive -fms-extensions -fshort-wchar -fPIC
# -mrtd
CXXEXTRA     = -fpermissive -fms-extensions -fshort-wchar -fPIC -fno-for-scope
# -mrtd

using_DEFINES   = \
			-include wine/winegccdef.h \
			-D"_DEBUG" \
			-D"_WINDOWS"

stlport_INCLUDE_PATH = \
			-I$(stlport_root)/stlport

msvc_INCLUDE_PATH = \
			-I$(msvc_root)/atl/include \
			-I$(msvc_root)/mfc/include \
			-I$(msvc_root)/include

using_INCLUDE_PATH = \
			$(stlport_INCLUDE_PATH) \
			$(msvc_INCLUDE_PATH) \
			-I$(wine_include)/msvcrt

WRCEXTRA    =-I$(msvc_root)/mfc/include

stlport_LIB_PATH = $(stlport_root)/lib
stlport_lib = stlport_wine_stldebug
# stlport_lib = stlport_wine_debug
# stlport_lib = stlport_wine

msvc_LIB_PATH = $(msvc_root)
msvc_lib = msvc

# use for dynamic-link (CPP-DLL) mfc and STL
	using_CPP_DLL_PATH = -L$(msvc_LIB_PATH)
	using_CPP_DLLS = $(msvc_lib)
#	using_STATIC_LIBS =
# /use for dynamic-link

# use for STATIC LINK mfc & stl
#	using_CPP_DLL_PATH =
#	using_CPP_DLLS =

	using_STATIC_LIBS = \
		$(stlport_LIB_PATH)/lib$(stlport_lib).a
#		$(msvc_LIB_PATH)/lib$(msvc_lib).a
# /use for STATIC LINK mfc & stl



using_DLLS_PATH = $(WINE_DLL_PATH) $(using_CPP_DLL_PATH)
using_DLLS     = $(WINE_DLLS) $(using_CPP_DLLS)

using_DEPENDS = $(msvc_DEPENDS)
