#define STRICT
#include <windows.h>
#include <stdio.h>

static void enum_dlg_controls(HWND hDlg)
{
    HWND hChild;

    for(hChild = GetWindow(hDlg, GW_CHILD); hChild; hChild = GetWindow(hChild, GW_HWNDNEXT))
    {
	char title[256];
	GetWindowText(hChild, title, 256);
	printf("%p, \"%s\", style %08lx\n", hChild, title, GetWindowLong(hChild, GWL_STYLE));
    }
}

static void test_GetNextDlgGroupItem(HWND hDlg)
{
    HWND hChild, hwndNext;

    printf("dialog handle %p\n", hDlg);
    hChild = GetNextDlgGroupItem(hDlg, 0, 0);
    printf("GetNextDlgGroupItem(hDlg, 0, 0) = %p\n", hChild);

    for(hChild = GetWindow(hDlg, GW_CHILD); hChild; hChild = GetWindow(hChild, GW_HWNDNEXT))
    {
	hwndNext = GetNextDlgGroupItem(hDlg, hChild, 0);
	printf("GetNextDlgGroupItem(hDlg, %p, 0) = %p\n", hChild, hwndNext);
    }

}

static void test_GetNextDlgTabItem(HWND hDlg)
{
    HWND hChild, hwndNext;

    printf("dialog handle %p\n", hDlg);
    hChild = GetNextDlgTabItem(hDlg, 0, 0);
    printf("GetNextDlgTabItem(hDlg, 0, 0) = %p\n", hChild);

    for(hChild = GetWindow(hDlg, GW_CHILD); hChild; hChild = GetWindow(hChild, GW_HWNDNEXT))
    {
	hwndNext = GetNextDlgTabItem(hDlg, hChild, 0);
	printf("GetNextDlgTabItem(hDlg, %p, 0) = %p\n", hChild, hwndNext);
    }

}

BOOL CALLBACK MyDlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
    switch(Msg) {
    case WM_INITDIALOG:
	ShowWindow(GetDlgItem(hDlg, 2), SW_HIDE);
	ShowWindow(GetDlgItem(hDlg, 3), SW_HIDE);
	ShowWindow(GetDlgItem(hDlg, 4), SW_HIDE);
	ShowWindow(GetDlgItem(hDlg, 5), SW_HIDE);
	ShowWindow(GetDlgItem(hDlg, 6), SW_HIDE);

	enum_dlg_controls(hDlg);
	test_GetNextDlgGroupItem(hDlg);
	test_GetNextDlgTabItem(hDlg);
	break;

    case WM_COMMAND:
	EndDialog(hDlg, TRUE);
	break;

    default: break;
    }

    return FALSE;
}

//int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
int main(void)
{
    DialogBoxParamA(GetModuleHandle(0),
		    MAKEINTRESOURCE(1),
		    0,
		    MyDlgProc,
		    0);
    return 0;
}
