/*
 * List of Win32 implementations
 */
typedef enum {
    W32_MS,             /* Microsoft implementation of Win32,
                           reported version of windows corresponds to real platform */
    W32_WINE            /* Wine Win32 implementation */
} W32_IMPL;

W32_IMPL get_w32_impl();
int get_checks_count( void );

void _start_todo( int condition, char *file, int line );
void _end_todo( char *file, int line );
int in_todo();

/* TODO block. Not thread-safe.
   Params:
     - condition - condition when TODO is active.
*/
#define START_TODO( condition ) \
    { _start_todo( condition, __FILE__, __LINE__ )
#define START_WINE_TODO \
    START_TODO( get_w32_impl() == W32_WINE )
#define END_TODO _end_todo( __FILE__, __LINE__ );}

#define TODO( condition, code ) \
    START_TODO( condition ); code; END_TODO
#define WINE_TODO( code ) \
    START_WINE_TODO; code; END_TODO

/* WONTFIX */
#define START_WONTFIX( condition ) \
    if (condition) { 
#define START_WINE_WONTFIX \
    START_WONTFIX( get_w32_impl() == W32_WINE )
#define END_WONTFIX }

#define WONTFIX( condition, code ) \
    START_WONTFIX( condition ); code; END_WONTFIX
#define WINE_WONTFIX( code ) \
    WONTFIX( get_w32_impl() == W32_WINE )

void _ok( int condition, char *msg, char *file, int line );

#define ok( condition, msg ) _ok( condition, msg, __FILE__, __LINE__ )
#define fail( msg ) _ok( 0, msg, __FILE__, __LINE__ )

void end_tests( void );
