#define _WIN32_IE    0x0500
#define _WIN32_WINNT 0x0501

#include <windows.h>
#include <wingdi.h>
#include <commctrl.h>

void paint(HWND hWnd)
{
	BLENDFUNCTION pixelblend = { AC_SRC_OVER, 0, 255, AC_SRC_ALPHA };

    unsigned long *buffer;
    int x, y;

	PAINTSTRUCT ps; 
	HDC hdc = BeginPaint(hWnd, &ps); 


    static HBITMAP hBmp = NULL;

    if ( hBmp==NULL )
    {
        BITMAPINFO bmp = { { sizeof(BITMAPINFOHEADER), 100, 100, 1, 32 } };

        void * pBits = NULL;

        hBmp = CreateDIBSection(NULL, & bmp, DIB_RGB_COLORS, & pBits, NULL, NULL);

        for ( y=0; y<100; y++)
        {
            BYTE * pPixel = (BYTE *) pBits + 100 * 4 * y;

            for (x=0; x<100; x++)
            {
                pPixel[0] = rand() % 255; 
                pPixel[1] = rand() % 255; 
                pPixel[2] = rand() % 255; 

                pPixel += 4;
            }
        }
    }

    BITMAP bmp;
    GetObject(hBmp, sizeof(BITMAP), & bmp);


    HDC     hMemDC = CreateCompatibleDC(hdc);
    HGDIOBJ hOld   = SelectObject(hMemDC, hBmp);

LARGE_INTEGER TimerFreq = {0, 0};
LARGE_INTEGER TimerCount = {0, 0};
LARGE_INTEGER TimerLast = {0, 0};
LARGE_INTEGER TimerStart = {0, 0};

#if 0
    /* Bitblt SRCCOPY test */
    {
        QueryPerformanceCounter(&TimerStart);
        for(x=0; x<400; x+=1)
        {
            for(y=0; y<400; y+=1)
                BitBlt(hdc, x, y, bmp.bmWidth, bmp.bmHeight, hMemDC, 0, 0, SRCCOPY);  // display the bitmap
        }
        QueryPerformanceCounter(&TimerCount);
        printf("bitblt counts/blit=%ld\n", (TimerCount.QuadPart - TimerStart.QuadPart)/(400*400));
    }
#endif
#if 0
    /* StretchBlt SCRCOPY no-stretching test */
    {
        QueryPerformanceCounter(&TimerStart);
        for(x=0; x<400; x+=1)
        {
            for(y=0; y<400; y+=1)
                StretchBlt(hdc, x, y, bmp.bmWidth, bmp.bmHeight, hMemDC, 0, 0, bmp.bmWidth, bmp.bmHeight, SRCCOPY);  // display the bitmap
        }
        QueryPerformanceCounter(&TimerCount);
        printf("stretchblt no-stretch counts/blit=%ld\n", (TimerCount.QuadPart - TimerStart.QuadPart)/(400*400));
    }
#endif
#if 1
    /* StretchBlt SRCCOPY 1x1 -> 20x20 blit */
    {
        QueryPerformanceCounter(&TimerStart);
        for(x=0; x<400; x+=1)
        {
            for(y=0; y<400; y+=1)
                StretchBlt(hdc, x, y, 20, 20, hMemDC, 0, 0, 1, 1, SRCCOPY);  // display the bitmap
        }
        QueryPerformanceCounter(&TimerCount);
        printf("stretchblt 1.0xStretch counts/blit=%ld\n", (TimerCount.QuadPart - TimerStart.QuadPart)/(400*400));
    }
#endif
#if 0
    /* StretchBlt SCRCOPY stretching test */
    {
        QueryPerformanceCounter(&TimerStart);
        for(x=0; x<400; x+=1)
        {
            for(y=0; y<400; y+=1)
                StretchBlt(hdc, x, y, bmp.bmWidth+1, bmp.bmHeight+1, hMemDC, 0, 0, bmp.bmWidth, bmp.bmHeight, SRCCOPY);  // display the bitmap
        }
        QueryPerformanceCounter(&TimerCount);
        printf("stretchblt ~1.0xStretch counts/blit=%ld\n", (TimerCount.QuadPart - TimerStart.QuadPart)/(400*400));
    }
#endif
#if 1
    /* StretchBlt SCRCOPY stretching test */
    {
        QueryPerformanceCounter(&TimerStart);
        for(x=0; x<200; x+=1)
        {
            for(y=0; y<200; y+=1)
                StretchBlt(hdc, x, y, bmp.bmWidth*2, bmp.bmHeight*2, hMemDC, 0, 0, bmp.bmWidth, bmp.bmHeight, SRCCOPY);  // display the bitmap
        }
        QueryPerformanceCounter(&TimerCount);
        printf("stretchblt 2xStretch counts/blit=%ld\n", (TimerCount.QuadPart - TimerStart.QuadPart)/(400*400));
    }
#endif
    SelectObject(hMemDC, hOld);
    DeleteObject(hMemDC);


    EndPaint(hWnd, &ps); 

}

LRESULT CALLBACK wndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch(message)
    {
    	case WM_PAINT:
    		paint(hWnd);
    		break;
    
        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }

    return 0;
}


int WINAPI WinMain(      
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPSTR lpCmdLine,
    int nCmdShow
)
{
	HMODULE hdll;

    InitCommonControls(); 

	WNDCLASSEX wcl;
	wcl.cbSize = sizeof(WNDCLASSEX);
	wcl.hInstance = hInstance;
	wcl.lpfnWndProc = (WNDPROC)wndProc;
	wcl.style = CS_HREDRAW | CS_VREDRAW;
	wcl.hIcon = LoadIcon(hInstance, IDC_ARROW);
	wcl.hIconSm = NULL;
	wcl.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcl.lpszMenuName = NULL;
	wcl.cbClsExtra = 0;
	wcl.cbWndExtra = 0;
	wcl.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wcl.lpszClassName = "myClass";

	if(!RegisterClassEx(&wcl))
		return 0;

	HWND hWnd = CreateWindow("myClass",
		"WindowTitle",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInstance,
		NULL);

	ShowWindow(hWnd, nCmdShow);

	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}


    return 0;
}