#!/bin/sh
# General GIT-Updater by Christian Lachner alias Gladiac
# v0.21 - heavily customized for wine
# NOTE: I love wine ;)

# SET ENABLE="yes" IF YOU ARE READY
ENABLE="yes";

# General Options
GIT="/usr/bin/git";	# GIT="~/bin/git";
MAKE="/usr/bin/make";
GCC="/usr/bin/gcc";
APP="WINE";
GITROOT="http://source.winehq.org/git/wine.git";
SRC="/usr/src";
TARGET="wine-git";
LOG=$SRC"/"$APP".log"; # /usr/src/WINE.log
#DEFAULT_MODE="2"; # Enable this if don't you want to set the '-2'-Param everytime; works with mode 0 and 1 too ;)

# Compiler-Commands
CONFIGURE="./configure";
DEPEND=$MAKE" depend";
COMPILE=$MAKE" all";
INSTALL=$MAKE" install";
UNINSTALL=$MAKE" uninstall";
#ADDITIONAL=$MAKE" programs";

# Colors
BLACK="0;30";	DGRAY="1;30";
BLUE="0;34";	LBLUE="1;34";
GREEN="0;32";	LGREEN="1;32";
CYAN="0;36";	LCYAN="1;36";
RED="0;31";		LRED="1;31";
PURPLE="0;35";	LPURPLE="1;35";
BROWN="0;33";	YELLOW="1;33";
LGRAY="0;37";	WHITE="1;37";

OK_COLOR=$LGREEN;
MODE_COLOR=$LBLUE;
ERROR_COLOR=$LRED;
INFO_COLOR=$YELLOW;

function usage {
echo -e "Usage: \033["$LGREEN"m"$0"\033[0m \033["$MODE_COLOR"m-mode\033[0m";
echo "";
echo "modes:";
echo -e " \033["$MODE_COLOR"m-0\033[0m   update the local source-tree";
echo -e " \033["$MODE_COLOR"m-1\033[0m   + compile the source";
echo -e " \033["$MODE_COLOR"m-2\033[0m   + install";
echo -e " \033["$MODE_COLOR"m-3\033[0m   no update; just compile the local source-tree and install";
echo "";
echo -e " \033["$MODE_COLOR"m-h\033[0m   displays this help ;)";
echo "";
echo -e "Report bugs to \033["$INFO_COLOR"mgladiac@gmail.com\033[0m";
}

if [ $ENABLE != "yes" ]; then
    echo -e "The Script has not been enabled... Please configure "$0" with an Editor -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
fi

if  [ $DEFAULT_MODE ]; then
	MODE=$DEFAULT_MODE;
fi

if [ $USER != "root" ]; then
	echo -e "You are not root -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
fi

if [ $1 ]; then
	case "$1" in
		-0 | 0)
			MODE=0;
			;;
		-1 | 1)
			MODE=1;
			;;
		-2 | 2)
			MODE=2;
			;;
		-3 | 3)
			MODE=3;
			;;
		-h | --help)
			usage;
			exit 0;
			;;
		*)
			echo -e "Unknown Parameter \"\033["$INFO_COLOR"m"$1"\033[0m\" entered...";
			echo "";
			usage;
			exit 1;
			;;
	esac
fi

case "$MODE" in
	0)
		echo -e $0": running in mode \"\033["$MODE_COLOR"m0\033[0m\"...";
		echo " -> only getting current git-tree!";
		;;
	1)
		echo -e $0": running in mode \"\033["$MODE_COLOR"m1\033[0m\"...";
		echo " -> getting current git-tree + compile!";
		;;
	2)
		echo -e $0": running in mode \"\033["$MODE_COLOR"m2\033[0m\"...";
		echo " -> getting current git-tree + compile + install!";
		;;
	3)
		echo -e $0": running in mode \"\033["$MODE_COLOR"m3\033[0m\"...";
		echo -e " -> just compile the current tree in \""$SRC"\"!";
		;;
	*)
		if [ $DEFAULT_MODE ]; then
			if [ $1 ]; then
				echo -e "Something messed up here; _This_ should really not happen... -> \033["$ERROR_COLOR"mexiting!\033[0m";
			else
				echo -e "I don't know the Mode \"\033["$MODE_COLOR"m"$MODE"\033[0m\"! Check DEFAULT_MODE -> \033["$MODE_COLOR"mexiting!\033[0m";
			fi
		else
			if [ $1 ]; then
				echo -e "Something messed up here; _This_ should really not happen... -> \033["$ERROR_COLOR"mexiting!\033[0m";
			else
				echo "No Parameter entered...";
				echo;
				usage;
				exit 1;
			fi
		fi
		exit 1;
		;;
esac

echo -n "Creating Logfile \""$LOG"\"... "; rm $LOG > /dev/null; touch $LOG;
if [ $? != 0 ]; then
	echo -e "\033["$INFO_COLOR"merror, but not fatal\033[0m.";
	echo "Could not create Logfile; Check Permissions and so on!";
	echo -n "Disabling logging... "; LOG="/dev/null"; echo -e "\033["$OK_COLOR"mdone.\033[0m";
else
	echo -e "\033["$OK_COLOR"mdone.\033[0m";
	echo -n "Writing Headers to Logfile... "; echo $APP" getwinegit.sh-Logfile" >> $LOG; date >> $LOG; echo $0" running in mode: "$MODE >> $LOG; echo >> $LOG;
	if [ $? != 0 ]; then
		echo -e "\033["$ERROR_COLOR"merror, but not fatal.\033[0m";
		echo -e "Could not write Headers; Check Permissions and so on!";
		echo -n "Disabling logging... "; LOG="/dev/null"; echo -e "\033["$OK_COLOR"mdone.\033[0m";
	else
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
	fi
fi

echo "checking needed Programs..." >> $LOG;

if [ $MODE != 3 ]; then
	echo -n "\$GIT... " >> $LOG;
	echo -n "Checking for GIT... ";
	if [ $GIT ]; then
		if [ -f $GIT ]; then
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
			echo $GIT" seems ok" >> $LOG;
		else
			echo -e "\033["$ERROR_COLOR"merror.\033[0m";
			echo "not found -> check path in \$GIT" >> $LOG;
			echo -e "GIT-Exec not found at \""$GIT"\"... is GIT installed? -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
		fi
	else
		echo "not set -> fatal!" >> $LOG;
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Variable \$GIT is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
	fi
fi

echo -n "\$MAKE... " >> $LOG;
echo -n "Checking for MAKE... ";
if [ $MAKE ]; then
	if [ -f $MAKE ]; then
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo $MAKE" seems ok" >> $LOG;
	else
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo "not found -> check path in \$MAKE" >> $LOG;
		echo -e "GIT-Exec not found at \""$MAKE"\"... is MAKE installed? -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
	fi
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$MAKE is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
fi

echo -n "\$GCC... " >> $LOG;
echo -n "Checking for GCC... ";
if [ $GCC ]; then
	if [ -f $GCC ]; then
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo $GCC" seems ok" >> $LOG;
        else
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo "not found -> check path in \$GCC" >> $LOG;
		echo -e "GIT-Exec not found at \""$GCC"\"... is GCC installed? -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
	fi
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$GCC is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
fi

echo >> $LOG;

echo "checking other Variables..." >> $LOG;
echo -n "Checking other Variables... ";

echo -n "\$APP ";
echo -n "\$APP... " >> $LOG;
if [ $APP ]; then
	echo $APP >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$APP is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;

fi

echo -n "\$GITROOT ";
echo -n "\$GITROOT... " >> $LOG;
if [ $GITROOT ]; then
	echo $GITROOT >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$GITROOT is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;

fi

echo -n "\$SRC ";
echo -n "\$SRC... " >> $LOG;
if [ $SRC ]; then
	echo $SRC >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$SRC is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;

fi

echo -n "\$TARGET ";
echo -n "\$TARGET... " >> $LOG;
if [ $TARGET ]; then
	echo $TARGET >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$TARGET is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;

fi

echo -n "\$LOG ";
echo -n "\$LOG... " >> $LOG;
if [ $LOG ]; then
	echo $LOG >> $LOG;
else
	echo "not set -> fatal!" >> $LOG;
	echo -e "\033["$ERROR_COLOR"merror.\033[0m";
	echo -e "Variable \$LOG is not set -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;

fi

echo -n "\$DEFAULT_MODE... " >> $LOG;
if [ $DEFAULT_MODE ]; then
	echo -n "\$DEFAULT_MODE ";
	echo $DEFAULT_MODE >> $LOG;
else
	echo "not set -> that's ok" >> $LOG;
fi

echo -e "\033["$OK_COLOR"mdone.\033[0m";

echo >> $LOG;

if [ $MODE != 3 ]; then
	echo -n "Changing to \""$SRC"\"... "; cd $SRC > /dev/null; echo -e "\033["$OK_COLOR"mdone.\033[0m";

	echo -n "Checking availability of "$APP"-tree in \""$SRC"\"... ";
	if [ -d $SRC"/"$TARGET ]; then 
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo -e "  Old "$APP"-tree found -> \033["$INFO_COLOR"mUpdate initiated!\033[0m";
		echo -n "Changing to \""$SRC"/"$TARGET"\"... "; cd $SRC/$TARGET; echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo -n "Cleaning "$APP"-Tree... "; $MAKE clean >> $LOG; echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo "Processing GIT-Update... "; $GIT pull >> $LOG;
		if [ $? != 0 ]; then
			echo "GIT-Pull failed!";
			echo -e " this happens, when the local git-tree is empty -> removing \033["$INFO_COLOR"m"$SRC"/"$TARGET"\033[0m!"; cd $SRC; rm -rf $SRC"/"$TARGET > /dev/null;
			echo -e "Update cancelled -> \033["$INFO_COLOR"mCheckout initiated!\033[0m";
			echo "Processing GIT-Checkout..."; $GIT clone $GITROOT $TARGET >> $LOG;
			if [ $? != 0 ]; then
			    echo -e "GIT-Checkout failed -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
			else
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
			fi
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi
	else
		echo -e "\033["$OK_COLOR"mdone.\033[0m";
		echo -e "  Old "$APP"-tree _NOT_ found -> \033["$INFO_COLOR"mCheckout initiated!\033[0m";
		echo "Processing GIT-Checkout..."; $GIT clone $GITROOT $TARGET >> $LOG;
		if [ $? != 0 ]; then
			echo -e "GIT-Checkout failed -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi
	fi
fi

if [ $MODE -ge 1 ]; then
	echo -n "Changing to \""$SRC"/"$TARGET"\"... "; cd $SRC/$TARGET &> /dev/null;
	if [ $? != 0 ]; then
		echo -e "\033["$ERROR_COLOR"merror.\033[0m";
		echo -e "Could not change to \""$SRC"/"$TARGET"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
	else
		echo -e "\033["$OK_COLOR"mdone.\033[0m";

		echo -n "Creating Makefile... "; $CONFIGURE >> $LOG;
		if [ $? != 0 ]; then
			echo -e "\033["$ERROR_COLOR"merror.\033[0m";
			echo -e "Something went wrong when executing \""$CONFIGURE"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi

		echo -n "Making Dependencies... "; $DEPEND >> $LOG;
		if [ $? != 0 ]; then
			echo -e "\033["$ERROR_COLOR"merror.\033[0m";
			echo -e "Something went wrong when executing \""$DEPEND"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi

		echo -n "Compiling... "; $COMPILE >> $LOG;
		if [ $? != 0 ]; then
			echo -e "\033["$ERROR_COLOR"merror.\033[0m";
			echo -e "Something went wrong when executing \""$COMPILE"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
		else
			echo -e "\033["$OK_COLOR"mdone.\033[0m";
		fi
#		echo -n "Compiling additional Stuff... "; $ADDITIONAL >> $LOG;
#        if [ $? != 0 ]; then
#			echo -e "\033["$ERROR_COLOR"merror.\033[0m";
#			echo -e "Something went wrong when executing \""$ADDITIONAL"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
#		else
#			echo -e "\033["$OK_COLOR"mdone.\033[0m";
#		fi

		if [ $MODE -ge 2 ]; then
			echo -n "Removing old "$APP"-Installation... "; $UNINSTALL >> $LOG;
			if [ $? != 0 ]; then
				echo -e "\033["$ERROR_COLOR"merror.\033[0m";
				echo -e "Something went wrong when executing \""$UNINSTALL"\" -> \033["$INFO_COLOR"merror, but not fatal!\033[0m";			# not fatal
#				echo -e "Something went wrong when executing \""$UNINSTALL"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;	# fatal
			else
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
			fi

			echo -n "Installing... "; $INSTALL >> $LOG;
			if [ $? != 0 ]; then
				echo -e "\033["$ERROR_COLOR"merror.\033[0m";
				echo -e "Something went wrong when executing \""$INSTALL"\" -> \033["$ERROR_COLOR"mexiting!\033[0m"; exit 1;
			else
				echo -e "\033["$OK_COLOR"mdone.\033[0m";
			fi
		fi
	fi
fi

echo;
echo -e $0": \033["$OK_COLOR"mdone!\033[0m"; echo >> $LOG; echo $APP" End of Logfile" >> $LOG; date >> $LOG; echo >> $LOG; exit 0;

