#!/bin/sh
#vim :set ts=4 noexpandtab ai:

BSCRIPT="$HOME/src/wine/build_wine.sh"
WINE_BUILD_REVISION=1

# Source email address
EMAIL='sorceror@the-shack.is-a-geek.net'
export EMAIL
REPLYTO='ben.klein@lamaresh.net'

#DESTEMAIL='shacklein@gmail.com'
DESTEMAIL='repository@lamaresh.net'

NO_TAR=0
NO_MAIL=0
KEEP_RAMDISK=''
OLD_PACK=0

help()
{
	echo "Usage: $CMD [--help] [-hkmt] [-r revision] <version> [distro ...]"
	echo " --help,"
	echo " -h        Display this help message"
	echo " -k        Keep the ramdisks mounted after compiling"
	echo " -m        Do not send mail about the packages being ready"
	echo " -p        Use previous packages"
	echo " -r        Specify minor package revision"
	echo " -t        Do not tarball packages after building (implies -m)"
	echo " version   Build packages of the specified version"
	echo " distro    Build packages only for the specified distros"
	exit
}

CMD=`basename "$0" .sh`
opts=`getopt -n "$CMD" -l 'help' -- 'hkmpr:t' "$@"` || help

eval set -- "$opts"
unset opts

while [ "$1" != '--' ]; do
	case "$1" in
		--help|-h) help ;;
		-k) KEEP_RAMDISK='-k' ;;
		-m) NO_MAIL=1 ;;
		-p) OLD_PACK=1 ;;
		-r) WINE_BUILD_REVISION="$2"; shift ;;
		-t) NO_TAR=1 ;;
	esac
	shift
done
shift

[ -z "$1" ] && echo "Don't know which version to build" && exit 1
VNUM="$1"
shift

echo "Will build $VNUM-$WINE_BUILD_REVISION"

build_raw()
{
	"$@"
	e=$?
	if [ "$e" -ne 0 ]; then
		echo "Oh noes! Error $e on building $NAME"
		return $e
	fi
	return 0
}

build_chroot()
{
	NAME="$1"
	build_raw schroot -n "$NAME"-wine-build -c "$NAME" -- "$BSCRIPT" ${WINE_BUILD_REVISION:+-r $WINE_BUILD_REVISION} "$VNUM" "$NAME"
	return $?
}

RSUF=${WINE_BUILD_REVISION:+"-$WINE_BUILD_REVISION"}

NATIVE='sid64'
LIST=${*:-'sid64 sid32 lenny64 lenny32 squeeze64 squeeze32'}
DONE=""
for thing in $LIST; do
	echo $thing
	CMD='build_chroot'
	GCC="gcc"
	which gcc-4.4 >/dev/null && GCC="gcc-4.4"
	[ "$thing" = "$NATIVE" ] && NAME="$NATIVE" && CMD='build_raw "$BSCRIPT" ${WINE_BUILD_REVISION:+-r $WINE_BUILD_REVISION} $KEEP_RAMDISK "$VNUM"' && export CC="ccache $GCC" || export CC="$GCC"

	echo "$thing" | grep -q '64$' && a='amd64' || a='i386'
	p="${thing}/wine_${VNUM}~winehq1${RSUF}_${a}.deb"
	[ "$OLD_PACK" = 1 -a -r "$p" ] && echo "Skipping $thing for '$p'" && continue
	echo "$DONE" | grep -q " $thing " || eval "$CMD" "$thing" || exit $?
	DONE="$DONE $thing "
done

[ "$NO_TAR" -eq 1 ] && echo "Yay!" && exit 0

cd ..
echo "tarring all the packages together"

DONE=`echo $DONE`
echo "$DONE" | grep -q ' ' && DONE="{$DONE}"
eval tar cjvf "wine/wine-$VNUM$RSUF.tar.bz2" 'wine/'`echo "$DONE"|tr -s " " ,`/wine*$VNUM~winehq1$RSUF* || exit $?

sftp -oPort=58429 -b - ftp@localhost <<EOF
cd wine
put "wine/wine-$VNUM$RSUF.tar.bz2"
EOF
rm "wine/wine-$VNUM$RSUF.tar.bz2"

echo "Yay! Now just email Maurilio"
[ "$NO_MAIL" -ne 1 ] && mutt -x -c "$REPLYTO" -s "Wine $VNUM ready" "$DESTEMAIL" << EOF
Packages for $VNUM are ready and tarballed for you :D
EOF
