#!/bin/bash
# pushd is a bashism

# Additional symlinks for etch AMD64 (building):
# ln -s libpng12.so.0.15.0 libpng12.so

# Additional [i386] packages for etch AMD64:
# * libxcomposite1
# * libhal1
# * libdbus-1-3
# * libcapi20
# * libssl0.9.8
# * libcupsys2

# Method: download i386 package and: dpkg -X $PKGFILE /emul/ia32-linux/

export EMAIL="ben.klein@lamaresh.net"
export DEBFULLNAME="Ben Klein"
export DEBEMAIL="$EMAIL"

SRCDIR="$HOME/src/wine"
RAMDISKDEV='ramdisk'
STAMP=`date '+%a, %d %b %Y %H:%M:%S %z'`

build_env ()
{
	until echo "$debian_chroot" | egrep -q '^(etch|lenny|squeeze|sid)(32|64)'; do
		printf '$debian_chroot not set correctly! please enter: '
		read debian_chroot
	done

	echo "Configuring build environment ..."

	RAMDISKMNT='/mnt/ramdisk'
	mount|grep -q "^$RAMDISKDEV " || mount "$RAMDISKDEV" || return 1
	[ -w "$RAMDISKMNT" ] || (umount "$RAMDISKDEV"; mount "$RAMDISKDEV") || return 3
	cd "$RAMDISKMNT" || return 2
}

build_get ()
{
	SRCBASE='wine-git'
	echo "$debian_chroot" | grep -q '^etch' && SRCBASE="${SRCBASE}-etch"
	echo "$debian_chroot" | grep -q '^lenny' && SRCBASE="${SRCBASE}-lenny"
	SRC="$SRCDIR/$SRCBASE"
	DIRSUFFIX="~winehq1"
	COMBDIR="${VERSION}${DIRSUFFIX}"
	rm -f wine_"${VNUM}${DIRSUFFIX}"*{dsc,gz}
	rm -rf "$SRCBASE"
	rm -rf "$COMBDIR"

	pushd "$SRC" > /dev/null
	echo "Updating source code ..."
	#git checkout master || return 4
	git fetch || return 5
	popd > /dev/null

	echo "Copying source code to build environment ..."
	echo "$SRC >> $PWD"
	cp -r "$SRC" . || return 1
	mv "$SRCBASE" "$COMBDIR" || return 2
	cd "$COMBDIR" || return 3

	echo "Grabbing correct version ..."
	git checkout -f "$VERSION" || return 6
	#git reset "$VERSION" || return 6
}

build_prepare ()
{
	JOBS=6

	echo "Preparing source for building ..."
	rm -rf debian
	touch "../wine_${VNUM}${DIRSUFFIX}.orig.tar.gz"
	yes | dh_make -s > /dev/null 
	[ "$?" -ne 0 ] && return 1

	ctrl="$SRCDIR/control-amd64"
	echo "$debian_chroot" | grep -q '32' && ctrl="$SRCDIR/control-i386"
	cp "$ctrl" debian/control || return 3

	MAKEFLAGS="-j$JOBS"
	JFLAG="$MAKEFLAGS"
	DEB_BUILD_OPTIONS="parallel=$JOBS"
	export DEB_BUILD_OPTIONS
	config=""

	echo "$debian_chroot" | grep -q 'etch' && export MAKEFLAGS && JFLAG="" && \
		config="--without-gnutls"

	echo "Restructuring build instructions"
	for each in "$SRCDIR"/needed_patches/*; do
		patch -p1 < "$each"
	done

	patch -p1 <<EOF
--- a/debian/rules	2010-05-10 09:55:56.442506914 +1000
+++ b/debian/rules	2010-05-10 09:57:57.000000000 +1000
@@ -10,4 +10,25 @@
 #export DH_VERBOSE=1
 
 %:
-	dh  \$@
+	dh  \$@ --parallel
+
+override_dh_strip:
+	dh_strip -Xusr/bin/wine-pthread -Xusr/bin/wine-kthread -Xusr/bin/wine --dbg-package=wine-dbg
+
+override_dh_auto_configure:
+	dh_auto_configure -- --verbose --prefix=/usr --disable-tests
+
+override_dh_shlibdeps:
+	true
+
+override_dh_builddeb:
+	dh_builddeb -- -z9 -Zlzma
+
+install: build
+	dh_testdir
+	dh_testroot
+	dh_prep
+	dh_installdirs
+
+	\$(MAKE) prefix=\$(CURDIR)/debian/wine/usr install-lib
+	\$(MAKE) prefix=\$(CURDIR)/debian/wine-dev/usr install-dev
EOF

	[ "$?" = 0 ] || patch -p1 <<EOF
--- a/debian/rules
+++ b/debian/rules
@@ -65,3 +65,4 @@
 	# Add here commands to install the package into debian/wine.
-	\$(MAKE) prefix=\$(CURDIR)/debian/wine/usr install
+	\$(MAKE) prefix=\$(CURDIR)/debian/wine/usr install-lib
+	\$(MAKE) prefix=\$(CURDIR)/debian/wine-dev/usr install-dev
 
@@ -92,3 +93,3 @@
 	dh_link
-	dh_strip
+	dh_strip -Xusr/bin/wine-pthread -Xusr/bin/wine-kthread -Xusr/bin/wine --dbg-package=wine-dbg
 	dh_compress
@@ -98,6 +99,6 @@
 	dh_installdeb
-	dh_shlibdeps
+	#dh_shlibdeps
 	dh_gencontrol
 	dh_md5sums
-	dh_builddeb
+	dh_builddeb -- -z9 -Zlzma
EOF

	[ "$?" = 0 ] || return 5
	cat > debian/changelog <<EOF
wine ($VNUM~winehq1-${WINE_BUILD_REVISION:-1}) unstable; urgency=low

  * Wine version $VNUM

 -- $DEBFULLNAME <$DEBEMAIL>  $STAMP
EOF
	[ "$?" -ne 0 ] && return 5
	if [ -z "$JFLAG" ]; then
		sed 's, -Zlzma,,' debian/rules > debian/rules.new
		mv debian/rules.new debian/rules
		chmod 755 debian/rules
	fi

	# Enable debugging symbols
	CFLAGS="-g"${CFLAGS:+" $CFLAGS"}
	export CFLAGS
	echo "$debian_chroot" | grep -q '64$' && LDFLAGS="$LDFLAGS -L/usr/local/lib32" && export LDFLAGS
	grep -q dh_auto_configure debian/rules || ./configure ${config:+"$config"} --verbose --prefix=/usr --disable-tests || return 4

	echo "Last chance to bail out! Will continue $debian_chroot in 10 seconds"
	sleep 10
}

build_action ()
{
	echo "Starting build $debian_chroot ..."

	FLAGS=${JFLAG:+"-Zlzma -z9 $JFLAG"}
	dpkg-buildpackage -uc -nc $FLAGS -rfakeroot || return 2
}

build_store ()
{
	echo "Moving build packages ..."

	[ -n "$debian_chroot" ] || debian_chroot='sid64'
	DESTDIR="$SRCDIR/$debian_chroot" #/$VERSION"
	DEBVERSION=`echo "$VERSION"|tr -- '-' '_'`'~winehq1'
	[ -d "$DESTDIR" ] || mkdir -p "$DESTDIR" || return 1
	cd ..
	rm *orig*gz
	mv {"wine-dev","wine-dbg"}"_$VNUM"* "${DEBVERSION}"* "$DESTDIR" || return 2
	echo "Packages copied to $DESTDIR"
}

build_clean()
{
	echo "Cleaning up build environment ..."
	cd
	umount "$RAMDISKDEV" || return 1
}

fatal ()
{
	echo "$2" >&2
	cd
	[ "$KEEP_RAMDISK" = 1 ] || umount "$RAMDISKDEV" || echo "umount error $?"
	exit $1
}

KEEP_RAMDISK=0
while echo "$1" | egrep -q '^-'; do
	if [ "$1" = "-k" ]; then
		KEEP_RAMDISK=1 && shift && echo 'Keeping ramdisk after failure'
	elif [ "$1" = "-r" ]; then
		WINE_BUILD_REVISION="$2" && shift 2
	else
		break
	fi
done

[ -n "$1" ] || fatal 1 "Don't know which version to build"
VNUM="$1"
VERSION="wine-$VNUM" 
[ -n "$2" ] && debian_chroot="$2"

trap fatal 15
trap fatal 2

build_env || fatal 1$? "Error in environment building"
build_get || fatal 2$? "Error in source code update"
build_prepare || fatal 3$? "Error in build preperation"
build_action || fatal 4$? "Error in building"
build_store || fatal 6$? "Error in package storage"
build_clean || fatal 5$? "Error in cleaning build"

# vim: set ts=4:
