#!/bin/sh

WINE_DIR=/prj/wine
#UNICODE=-D_UNICODE
INCLUDE="-I. -I$WINE_DIR/include -I$WINE_DIR/include/msvcrt"
FLAGS="-fPIC -fshort-wchar"
NAME=$1


#gcc -E $INCLUDE $UNICODE -g -O2 -Wall -mpreferred-stack-boundary=2 $FLAGS -DSTRICT -D_REENTRANT -o $NAME.pp1 $NAME.c
gcc -c $INCLUDE $UNICODE -g -O2 -Wall -mpreferred-stack-boundary=2 $FLAGS -DSTRICT -D_REENTRANT -o $NAME.o $NAME.c
LD_LIBRARY_PATH="$WINE_DIR/unicode:$LD_LIBRARY_PATH"
$WINE_DIR/tools/winebuild/winebuild -fPIC -L $WINE_DIR/dlls -sym $NAME.o -o $NAME.spec.c -spec $NAME.spec
gcc -c $INCLUDE $UNICODE -g -O2 -Wall -mpreferred-stack-boundary=2 $FLAGS -DSTRICT -D_REENTRANT -o $NAME.spec.o $NAME.spec.c
gcc -shared -Wl,-Bsymbolic -o $NAME.so $NAME.o $NAME.spec.o -L$WINE_DIR/library -lwine -lncurses -lm  -lutil -ldl
        

