#include <windows.h>

static HWND hwndBackPanel;
static HWND hwndFrontPanel;

static LRESULT CALLBACK BackPanelWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch (msg)
	{
	case WM_ACTIVATE:
        if (LOWORD(wParam) != WA_INACTIVE)
        {
		  /* Being activated - Set our front window to the foreground */
		  SetForegroundWindow(hwndFrontPanel);
        }
		break;
	}
    return DefWindowProc(hwnd,msg,wParam,lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd, INT nShow)
{
	WNDCLASS wc;
	MSG msg;

	memset(&wc,0,sizeof(WNDCLASS));
	wc.style = CS_HREDRAW|CS_VREDRAW |CS_DBLCLKS ;
	wc.hInstance = hInstance;
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName = 0;
	wc.hCursor = LoadCursor(NULL,IDC_ARROW);
	wc.hIcon = LoadIcon(NULL,IDI_APPLICATION);

	wc.lpszClassName = "BackPanel";
	wc.lpfnWndProc = (WNDPROC)BackPanelWndProc;
	RegisterClass(&wc);

	wc.lpszClassName = "FrontPanel";
	wc.lpfnWndProc = (WNDPROC)DefWindowProc;
	RegisterClass(&wc);

	hwndBackPanel = CreateWindow("BackPanel","backpanel",
		WS_MINIMIZEBOX|WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN|WS_MAXIMIZEBOX|WS_CAPTION|WS_BORDER|WS_SYSMENU|WS_THICKFRAME,
		CW_USEDEFAULT,0,CW_USEDEFAULT,0,
		NULL,
		NULL,
		hInstance,
		NULL);

	hwndFrontPanel = CreateWindow("FrontPanel","frontpanel",
		WS_MINIMIZEBOX|WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN|WS_MAXIMIZEBOX|WS_CAPTION|WS_BORDER|WS_SYSMENU|WS_THICKFRAME,
		CW_USEDEFAULT,0,CW_USEDEFAULT,0,
		NULL,
		NULL,
		hInstance,
		NULL);

	ShowWindow(hwndBackPanel,SW_SHOW);
	ShowWindow(hwndFrontPanel,SW_SHOW);

	while (GetMessage(&msg,NULL,0,0))
    {
		if (!TranslateAccelerator(msg.hwnd,0,&msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return msg.wParam;
}
