

#define INITGUID

#include <windows.h>
#include <stdio.h>

#include <d3d11shader.h>
#include <d3d10_1.h>
#include <d3d10_1shader.h>
#include <d3d10.h>

/* d3d11shader (version 40-42) */
DEFINE_GUID(IID_ID3D11ShaderReflection_42, 0x17f27486, 0xa342, 0x4d10, 0x88, 0x42, 0xab, 0x08, 0x74, 0xe7, 0xf6, 0x70);

#define INTERFACE ID3D11ShaderReflection_42
DECLARE_INTERFACE_(ID3D11ShaderReflection_42, IUnknown)
{
    /* IUnknown methods */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID *object) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;
    /* ID3D11ShaderReflection methods */
    STDMETHOD(GetDesc)(THIS_ D3D11_SHADER_DESC *desc) PURE;
    STDMETHOD_(struct ID3D11ShaderReflectionConstantBuffer *, GetConstantBufferByIndex)(THIS_ UINT index) PURE;
    STDMETHOD_(struct ID3D11ShaderReflectionConstantBuffer *, GetConstantBufferByName)(THIS_ LPCSTR name) PURE;
    STDMETHOD(GetResourceBindingDesc)(THIS_ UINT index, D3D11_SHADER_INPUT_BIND_DESC *desc) PURE;
    STDMETHOD(GetInputParameterDesc)(THIS_ UINT index, D3D11_SIGNATURE_PARAMETER_DESC *desc) PURE;
    STDMETHOD(GetOutputParameterDesc)(THIS_ UINT index, D3D11_SIGNATURE_PARAMETER_DESC *desc) PURE;
    STDMETHOD(GetPatchConstantParameterDesc)(THIS_ UINT index, D3D11_SIGNATURE_PARAMETER_DESC *desc) PURE;
    STDMETHOD_(struct ID3D11ShaderReflectionVariable *, GetVariableByName)(THIS_ LPCSTR name) PURE;
    STDMETHOD(GetResourceBindingDescByName)(THIS_ LPCSTR name, D3D11_SHADER_INPUT_BIND_DESC *desc) PURE;
    STDMETHOD_(UINT, GetMovInstructionCount)(THIS) PURE;
    STDMETHOD_(UINT, GetMovcInstructionCount)(THIS) PURE;
    STDMETHOD_(UINT, GetConversionInstructionCount)(THIS) PURE;
    STDMETHOD_(UINT, GetBitwiseInstructionCount)(THIS) PURE;
    STDMETHOD_(D3D_PRIMITIVE, GetGSInputPrimitive)(THIS) PURE;
    STDMETHOD_(BOOL, IsSampleFrequencyShader)(THIS) PURE;
    STDMETHOD_(UINT, GetNumInterfaceSlots)(THIS) PURE;
    STDMETHOD(GetMinFeatureLevel)(THIS_ enum D3D_FEATURE_LEVEL *level) PURE;
};
#undef INTERFACE

HRESULT (__stdcall * d3dreflect)(const char *data, SIZE_T data_size, REFIID riid, void **refl) = 0;
HRESULT (__stdcall * d3d10reflectshader)(const void *data, SIZE_T data_size, ID3D10ShaderReflection **refl) = 0;
HRESULT (__stdcall * d3dx10reflectshader)(const char *data, SIZE_T data_size, ID3D10ShaderReflection1 **refl) = 0;
/*
HRESULT (__stdcall * d3dreflectcode)(const char *data, SIZE_T data_size, REFIID riid, void **refl) = 0;
HRESULT (__stdcall * d3dreflectcode)(const char *data, SIZE_T data_size, ID3DBlob **blob) = 0;
*/

static HMODULE dll_handle = NULL;

static DWORD test_shader[] = {
0x43425844, 0x77c6324f, 0xfd27948a, 0xe6958d31, 0x53361cba, 0x00000001, 0x000001d8, 0x00000005,
0x00000034, 0x0000008c, 0x000000e4, 0x00000118, 0x0000015c, 0x46454452, 0x00000050, 0x00000000,
0x00000000, 0x00000000, 0x0000001c, 0xfffe0400, 0x00000100, 0x0000001c, 0x7263694d, 0x666f736f,
0x52282074, 0x4c482029, 0x53204c53, 0x65646168, 0x6f432072, 0x6c69706d, 0x39207265, 0x2e39322e,
0x2e323539, 0x31313133, 0xababab00, 0x4e475349, 0x00000050, 0x00000002, 0x00000008, 0x00000038,
0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000f0f, 0x00000041, 0x00000000, 0x00000000,
0x00000003, 0x00000001, 0x0000000f, 0x49534f50, 0x4e4f4954, 0x5f565300, 0x49534f50, 0x4e4f4954,
0xababab00, 0x4e47534f, 0x0000002c, 0x00000001, 0x00000008, 0x00000020, 0x00000000, 0x00000001,
0x00000003, 0x00000000, 0x0000000f, 0x505f5653, 0x5449534f, 0x004e4f49, 0x52444853, 0x0000003c,
0x00010040, 0x0000000f, 0x0300005f, 0x001010f2, 0x00000000, 0x04000067, 0x001020f2, 0x00000000,
0x00000001, 0x05000036, 0x001020f2, 0x00000000, 0x00101e46, 0x00000000, 0x0100003e, 0x54415453,
0x00000074, 0x00000002, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static const char *names_d3dreflect[] =
{
    "d3dcompiler_40.dll",
    "d3dcompiler_41.dll",
    "d3dcompiler_42.dll",
    "d3dcompiler_43.dll",
};

static const char *names_d3dreflectcode[] =
{
    "d3dcompiler_33.dll",
    "d3dcompiler_34.dll",
    "d3dcompiler_35.dll",
    "d3dcompiler_36.dll",
    "d3dcompiler_37.dll",
    "d3dcompiler_38.dll",
    "d3dcompiler_39.dll",
};

static const char *names_d3d10reflectshader[] =
{
    "d3d10.dll",
};

static const char *names_d3dx10reflectshader[] =
{
    "d3dx10_33.dll",
    "d3dx10_34.dll",
    "d3dx10_35.dll",
    "d3dx10_36.dll",
    "d3dx10_37.dll",
    "d3dx10_38.dll",
    "d3dx10_39.dll",
};

#define RELEASE(x) if (x) x->lpVtbl->Release(x); x = NULL;
#define QUERRY(x, y, z) if (x) {x->lpVtbl->QueryInterface(x, y, (void **)&z); printf("\tgot %s from QuerryInterface(%s, %s, &%s)\n", z ? #z : "NULL", #x, #y, #z); RELEASE(z)}

int main(void)
{
    ID3D11ShaderReflection *ref11 = NULL;
    ID3D11ShaderReflection_42 *ref11_42 = NULL;
    ID3D10ShaderReflection1 *ref10_1 = NULL;
    ID3D10ShaderReflection *ref10 = NULL;
    unsigned int i;
    HRESULT hr;

    printf("D3D10ReflectShader\n");
    for (i = 0; i < sizeof(names_d3d10reflectshader)/sizeof(*names_d3d10reflectshader); i++)
    {
        printf("%s: ", names_d3d10reflectshader[i]);
        dll_handle = LoadLibraryA(names_d3d10reflectshader[i]);
        if (!dll_handle) continue;

        d3d10reflectshader = (void *)GetProcAddress(dll_handle, "D3D10ReflectShader");
        if (!d3d10reflectshader)
        {
            FreeLibrary(dll_handle);
            printf("return\n");
            continue;
        }

        hr = d3d10reflectshader((const void *)test_shader, test_shader[6], &ref10);
        printf("ref10: %x\n", hr);
        QUERRY(ref10, &IID_ID3D10ShaderReflection1, ref10_1)
        QUERRY(ref10, &IID_ID3D11ShaderReflection_42, ref11_42)
        QUERRY(ref10, &IID_ID3D11ShaderReflection, ref11)
        RELEASE(ref10)

        FreeLibrary(dll_handle);
    }

    printf("D3DX10ReflectShader\n");
    for (i = 0; i < sizeof(names_d3dx10reflectshader)/sizeof(*names_d3dx10reflectshader); i++)
    {
        printf("%s: ", names_d3dx10reflectshader[i]);
        dll_handle = LoadLibraryA(names_d3dx10reflectshader[i]);
        if (!dll_handle) continue;;

        d3dx10reflectshader = (void *)GetProcAddress(dll_handle, "D3DX10ReflectShader");
        if (!d3dx10reflectshader)
        {
            FreeLibrary(dll_handle);
            printf("return\n");
            continue;
        }

        hr = d3dx10reflectshader((const char *)test_shader, test_shader[6], &ref10_1);
        printf("ref10_1: %x\n", hr);
        QUERRY(ref10_1, &IID_ID3D10ShaderReflection, ref10)
        QUERRY(ref10_1, &IID_ID3D11ShaderReflection_42, ref11_42)
        QUERRY(ref10_1, &IID_ID3D11ShaderReflection, ref11)
        RELEASE(ref10_1)

        FreeLibrary(dll_handle);
    }
/*
    printf("D3DReflectCode\n");
    ID3D10Blob *blob;
    for (i = 0; i < sizeof(names_d3dreflectcode)/sizeof(*names_d3dreflectcode); i++)
    {
        printf("%s: \n", names_d3dreflectcode[i]);
        dll_handle = LoadLibraryA(names_d3dreflectcode[i]);
        if (!dll_handle) continue;

        d3dreflectcode = (void *)GetProcAddress(dll_handle, "D3DReflectCode");
        if (!d3dreflectcode)
        {
            FreeLibrary(dll_handle);
            printf("return\n");
            continue;
        }

        hr = d3dreflectcode((const char *)test_shader, test_shader[6], &blob);
        printf("ref10: %x\n", hr);

        FreeLibrary(dll_handle);
    }
*/
    printf("D3DReflect\n");
    for (i = 0; i < sizeof(names_d3dreflect)/sizeof(*names_d3dreflect); i++)
    {
        printf("%s:\n", names_d3dreflect[i]);
        dll_handle = LoadLibraryA(names_d3dreflect[i]);
        if (!dll_handle) continue;

        d3dreflect = (void *)GetProcAddress(dll_handle, "D3DReflect");
        if (!d3dreflect)
        {
            FreeLibrary(dll_handle);
            printf("return\n");
            continue;
        }

        hr = d3dreflect((const char *)test_shader, test_shader[6], &IID_ID3D10ShaderReflection, (void **)&ref10);
        printf("\tref10: %x\n", hr);
        QUERRY(ref10, &IID_ID3D10ShaderReflection1, ref10_1)
        QUERRY(ref10, &IID_ID3D11ShaderReflection_42, ref11_42)
        QUERRY(ref10, &IID_ID3D11ShaderReflection, ref11)
        RELEASE(ref10)

        hr = d3dreflect((const char *)test_shader, test_shader[6], &IID_ID3D10ShaderReflection1, (void **)&ref10_1);
        printf("\tref10_1: %x\n", hr);
        QUERRY(ref10_1, &IID_ID3D10ShaderReflection, ref10)
        QUERRY(ref10_1, &IID_ID3D11ShaderReflection_42, ref11_42)
        QUERRY(ref10_1, &IID_ID3D11ShaderReflection, ref11)
        RELEASE(ref10_1)

        hr = d3dreflect((const char *)test_shader, test_shader[6], &IID_ID3D11ShaderReflection_42, (void **)&ref11_42);
        printf("\tref11_42: %x\n", hr);
        QUERRY(ref11_42, &IID_ID3D10ShaderReflection, ref10)
        QUERRY(ref11_42, &IID_ID3D10ShaderReflection1, ref10_1)
        QUERRY(ref11_42, &IID_ID3D11ShaderReflection, ref11)
        RELEASE(ref11_42)

        hr = d3dreflect((const char *)test_shader, test_shader[6], &IID_ID3D11ShaderReflection, (void **)&ref11);
        printf("\tref11: %x\n", hr);
        QUERRY(ref11, &IID_ID3D10ShaderReflection, ref10)
        QUERRY(ref11, &IID_ID3D10ShaderReflection1, ref10_1)
        QUERRY(ref11, &IID_ID3D11ShaderReflection_42, ref11_42)
        RELEASE(ref11)

        FreeLibrary(dll_handle);
    }
}
