/*
 * aligntest - A basic win32 app showing various text
 *             alignments and their style flags. A (C)
 *             shows when SS_CENTERIMAGE has been added
 *             to the style.
 *
 * Copyright 2005 n0dalus <n0dalus+wine@gmail.com>
 */

#include <windows.h>

#define AlignText(style, name, x, y)\
    CreateWindow("Static", name, style | WS_CHILD | WS_VISIBLE,\
            x, y, 180, 60, hWnd, NULL, hInst, NULL);
#define AlignTextC(style, name, x, y)\
    AlignText(style | SS_CENTERIMAGE, name "(C)", x, y);

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

INT WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmd, INT nCmd) {
    HWND hWnd;
    MSG uMsg;
    WNDCLASS wCls;

    // Create window
    wCls.style = CS_HREDRAW | CS_VREDRAW;
    wCls.lpfnWndProc = WndProc;
    wCls.cbClsExtra = 0;
    wCls.cbWndExtra = 0;
    wCls.hInstance = hInst;
    wCls.hIcon = 0;
    wCls.hCursor = LoadCursor(NULL, IDC_ARROW);
    wCls.hbrBackground = GetStockObject(GRAY_BRUSH);
    wCls.lpszMenuName = NULL;
    wCls.lpszClassName = "AlignTest";

    RegisterClass(&wCls);

    hWnd = CreateWindow("AlignTest", "Text Alignment", WS_OVERLAPPEDWINDOW,
            CW_USEDEFAULT, CW_USEDEFAULT, 560, 280, NULL, NULL, hInst, NULL);

    AlignText(SS_LEFT, "SS_LEFT", 2, 2);
    AlignText(SS_CENTER, "SS_CENTER", 184, 2);
    AlignText(SS_RIGHT, "SS_RIGHT", 366, 2);
    AlignText(SS_RIGHTJUST, "SS_RIGHTJUST", 2, 64);
    AlignText(SS_SIMPLE, "SS_SIMPLE", 184, 64);
    AlignText(SS_LEFTNOWORDWRAP, "SS_LEFTNOWORDWRAP", 366, 64);
    AlignTextC(SS_LEFT, "SS_LEFT", 2, 126);
    AlignTextC(SS_CENTER, "SS_CENTER", 184, 126);
    AlignTextC(SS_RIGHT, "SS_RIGHT", 366, 126);
    AlignTextC(SS_RIGHTJUST, "SS_RIGHTJUST", 2, 188);
    AlignTextC(SS_SIMPLE, "SS_SIMPLE", 184, 188);
    AlignTextC(SS_LEFTNOWORDWRAP, "SS_LEFTNOWORDWRAP", 366, 188);

    ShowWindow(hWnd, SW_SHOWNORMAL);
    UpdateWindow(hWnd);

    while(GetMessage(&uMsg, NULL, 0, 0)) {
        TranslateMessage(&uMsg);
        DispatchMessage(&uMsg);
    }

    return uMsg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
    switch(uMsg) {
        case WM_DESTROY:
            PostQuitMessage(WM_QUIT);
            break;
    }
    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}
