/*
 * SDL DC graphics
 *
 * Copyright 1999 Patrik Stridvall
 * Copyright 2002 TransGaming Technologies, Inc.
 */

#include "config.h"

#include "winnls.h"
#include "gdi.h"
#include "debugtools.h"
#include "sdldrv.h"

DEFAULT_DEBUG_CHANNEL(sdldrv);

/***********************************************************************
 *		SDLDRV_DC_Arc
 */
BOOL SDLDRV_DC_Arc(DC *dc, INT left, INT top, INT right, INT bottom,
		   INT xstart, INT ystart, INT xend, INT yend)
{
  FIXME("(%p, %d, %d, %d, %d, %d, %d, %d, %d): stub\n",
	dc, left, top, right, bottom, xstart, ystart, xend, yend);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_Chord
 */
BOOL SDLDRV_DC_Chord(DC *dc, INT left, INT top, INT right, INT bottom,
		     INT xstart, INT ystart, INT xend, INT yend)
{
  FIXME("(%p, %d, %d, %d, %d, %d, %d, %d, %d): stub\n",
	dc, left, top, right, bottom, xstart, ystart, xend, yend);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_Ellipse
 */
BOOL SDLDRV_DC_Ellipse(DC *dc, INT left, INT top, INT right, INT bottom)
{
  FIXME("(%p, %d, %d, %d, %d): stub\n",
	dc, left, top, right, bottom);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_ExtFloodFill
 */
BOOL SDLDRV_DC_ExtFloodFill(DC *dc, INT x, INT y,
			    COLORREF color, UINT fillType)
{
  FIXME("(%p, %d, %d, 0x%08lx, %u): stub\n", dc, x, y, color, fillType);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_GetPixel
 */
COLORREF SDLDRV_DC_GetPixel(DC *dc, INT x, INT y)
{
  FIXME("(%p, %d, %d): stub\n", dc, x, y);

  return RGB(100,20,0); /* FIXME: Always returns black */
}

/***********************************************************************
 *		SDLDRV_DC_LineTo
 */
BOOL SDLDRV_DC_LineTo(DC *dc, INT x, INT y)
{
  FIXME("(%p, %d, %d): stub\n", dc, x, y);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_PaintRgn
 */
BOOL SDLDRV_DC_PaintRgn(DC *dc, HRGN hrgn)
{
  FIXME("(%p, 0x%04x): stub\n", dc, hrgn);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_Pie
 */
BOOL SDLDRV_DC_Pie(DC *dc, INT left, INT top, INT right, INT bottom,
		   INT xstart, INT ystart, INT xend, INT yend)
{
  FIXME("(%p, %d, %d, %d, %d, %d, %d, %d, %d): stub\n",
	dc, left, top, right, bottom, xstart, ystart, xend, yend);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_Polygon
 */
BOOL SDLDRV_DC_Polygon(DC *dc, const POINT* pt, INT count)
{
  FIXME("(%p, %p, %d): stub\n", dc, pt, count);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_Polyline
 */
BOOL SDLDRV_DC_Polyline(DC *dc, const POINT* pt, INT count)
{
  FIXME("(%p, %p, %d): stub\n", dc, pt, count);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_PolyPolygon
 */
BOOL SDLDRV_DC_PolyPolygon(DC *dc, const POINT* pt, const INT* counts, UINT polygons)
{
  FIXME("(%p, %p, %p, %u): stub\n", dc, pt, counts, polygons);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_PolyPolyline
 */
BOOL SDLDRV_DC_PolyPolyline(DC *dc, const POINT* pt, const DWORD* counts, DWORD polylines)
{
  FIXME("(%p, %p, %p, %lu): stub\n", dc, pt, counts, polylines);
  
  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_Rectangle
 */
BOOL SDLDRV_DC_Rectangle(DC *dc, INT left, INT top, INT right, INT bottom)
{
  FIXME("(%p, %d, %d, %d, %d): stub\n", dc, left, top, right, bottom);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_RoundRect
 */
BOOL SDLDRV_DC_RoundRect(DC *dc, INT left, INT top, INT right,
			 INT bottom, INT ell_width, INT ell_height)
{
  FIXME("(%p, %d, %d, %d, %d, %d, %d): stub\n", 
	dc, left, top, right, bottom, ell_width, ell_height);
  
  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_SetBkColor
 */
COLORREF SDLDRV_DC_SetBkColor(DC *dc, COLORREF color)
{
  COLORREF oldColor;

  TRACE("(%p, 0x%08lx)\n", dc, color);  

  oldColor = dc->backgroundColor;
  dc->backgroundColor = color;

  return oldColor;
}

/***********************************************************************
 *		SDLDRV_DC_SetPixel
 */
COLORREF SDLDRV_DC_SetPixel(DC *dc, INT x, INT y, COLORREF color)
{
  FIXME("(%p, %d, %d, 0x%08lx): stub\n", dc, x, y, color);

  return RGB(0,0,0); /* FIXME: Always returns black */
}

/***********************************************************************
 *		SDLDRV_DC_SetTextColor
 */
COLORREF SDLDRV_DC_SetTextColor(DC *dc, COLORREF color)
{
  COLORREF oldColor;

  TRACE("(%p, 0x%08lx)\n", dc, color);
  
  oldColor = dc->textColor;
  dc->textColor = color;
  
  return oldColor;
}


/***********************************************************************
 *		SDLDRV_DC_BitBlt
 */
BOOL SDLDRV_DC_BitBlt(DC *dcDst, INT xDst, INT yDst,
		      INT width, INT height, DC *dcSrc,
		      INT xSrc, INT ySrc, DWORD rop)
{
  SDLDRV_PDEVICE *pDst, *pSrc;
  SDL_Rect rsrc, rdst;

  pSrc = dcSrc->physDev;
  pDst = dcDst->physDev;

  rsrc.x = xSrc;
  rsrc.y = ySrc;
  rsrc.w = width;
  rsrc.h = height;

  rdst.x = xDst;
  rdst.y = yDst;

  if (rop == SRCCOPY
      || rop == SRCPAINT /* hack */) {
    TRACE("(%p, %d, %d, %d, %d, %p, %d, %d, %06lx): stub\n",
	  dcDst, xDst, yDst, width, height, 
	  dcSrc, xSrc, ySrc, rop
    );

    SDL_BlitSurface(pSrc->surface, &rsrc, pDst->surface, &rdst);

    return TRUE;
  }

  FIXME("(%p, %d, %d, %d, %d, %p, %d, %d, %06lx): stub\n",
	dcDst, xDst, yDst, width, height, 
	dcSrc, xSrc, ySrc, rop
  );

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_PatBlt
 */
BOOL SDLDRV_DC_PatBlt(DC *dc, INT left, INT top,
		      INT width, INT height, DWORD rop)
{
  SDLDRV_PDEVICE *physDev = dc->physDev;
  SDL_Rect rect;


  rect.x = left;
  rect.y = top;
  rect.w = width;
  rect.h = height;

  if (rop == BLACKNESS) {
    TRACE("(%p, %d, %d, %d, %d, %06lx): stub\n",
	  dc, left, top, width, height, rop
    );
    SDL_FillRect(physDev->surface, &rect,
		 SDL_MapRGB(physDev->surface->format,
			    0, 0, 0));
    return TRUE;
  }
  else if (rop == WHITENESS) {
    TRACE("(%p, %d, %d, %d, %d, %lu): stub\n",
	  dc, left, top, width, height, rop
    );
    SDL_FillRect(physDev->surface, &rect,
		 SDL_MapRGB(physDev->surface->format,
			    0xff, 0xff, 0xff));
    return TRUE;
  }

  FIXME("(%p, %d, %d, %d, %d, %06lx): stub\n",
	dc, left, top, width, height, rop
  );

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_StretchBlt
 */
BOOL SDLDRV_DC_StretchBlt(DC *dcDst, INT xDst, INT yDst,
			  INT widthDst, INT heightDst,
			  DC *dcSrc, INT xSrc, INT ySrc,
			  INT widthSrc, INT heightSrc, DWORD rop)
{
  if (widthDst == widthSrc && heightDst == heightSrc) {
    TRACE("(%p, %d, %d, %d, %d, %p, %d, %d, %d, %d, %06lx): stub\n",
	  dcDst, xDst, yDst, widthDst, heightDst,
	  dcSrc, xSrc, ySrc, widthSrc, heightSrc, rop
    );
    /* hack: assume BitBlt (this is incorrect if the
     * DCs don't use MM_TEXT mapping) */
    return SDLDRV_DC_BitBlt(dcDst, xDst, yDst, widthDst, heightDst,
			    dcSrc, xSrc, ySrc, rop);
  }

  FIXME("(%p, %d, %d, %d, %d, %p, %d, %d, %d, %d, %06lx): stub\n",
	dcDst, xDst, yDst, widthDst, heightDst,
	dcSrc, xSrc, ySrc, widthSrc, heightSrc, rop
  );

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_ExtTextOut
 */
BOOL SDLDRV_DC_ExtTextOut(DC *dc, INT x, INT y, UINT flags,
			  const RECT *lpRect, LPCWSTR str, UINT count,
			  const INT *lpDx)
{
  FIXME("(%p, %d, %d, 0x%08x, %p, %s, %d, %p): stub\n",
	dc, x, y, flags, lpRect, debugstr_wn(str,count), count, lpDx);

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_GetCharWidth
 */
BOOL SDLDRV_DC_GetCharWidth(DC *dc, UINT firstChar, UINT lastChar,
			    LPINT buffer)
{
  UINT c;
  /* SDLDRV_PDEVICE *physDev = (SDLDRV_PDEVICE *) dc->physDev; */

  FIXME("(%p, %u, %u, %p): semistub\n", dc, firstChar, lastChar, buffer);

  for(c=firstChar; c<=lastChar; c++) {
    buffer[c-firstChar] = 1;
  }

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_GetTextExtentPoint
 */
BOOL SDLDRV_DC_GetTextExtentPoint(DC *dc, LPCWSTR str, INT count,
				  LPSIZE size)
{
  /* SDLDRV_PDEVICE *physDev = (SDLDRV_PDEVICE *) dc->physDev; */

  TRACE("(%p, %s, %d, %p)\n", dc, debugstr_wn(str, count), count, size);

  size->cx = count;
  size->cy = 1;

  return TRUE;
}

/***********************************************************************
 *		SDLDRV_DC_GetTextMetrics
 */
BOOL SDLDRV_DC_GetTextMetrics(DC *dc, LPTEXTMETRICW lptm)
{
  /* SDLDRV_PDEVICE *physDev = (SDLDRV_PDEVICE *) dc->physDev; */

  TRACE("(%p, %p)\n", dc, lptm);

  lptm->tmHeight = 1;
  lptm->tmAscent = 0;
  lptm->tmDescent = 0;
  lptm->tmInternalLeading = 0;
  lptm->tmExternalLeading = 0;
  lptm->tmAveCharWidth = 1;
  lptm->tmMaxCharWidth = 1;
  lptm->tmWeight = FW_MEDIUM;
  lptm->tmOverhang = 0;
  lptm->tmDigitizedAspectX = 1;
  lptm->tmDigitizedAspectY = 1;
  lptm->tmFirstChar = 32;
  lptm->tmLastChar = 255;
  lptm->tmDefaultChar = 0;
  lptm->tmBreakChar = 32;
  lptm->tmItalic = FALSE;
  lptm->tmUnderlined = FALSE;
  lptm->tmStruckOut = FALSE;
  lptm->tmPitchAndFamily = TMPF_FIXED_PITCH|TMPF_DEVICE;
  lptm->tmCharSet = ANSI_CHARSET;

  return TRUE;
}
