/*
 * SDL DC objects
 *
 * Copyright 1999 Patrik Stridvall
 * Copyright 2002 TransGaming Technologies, Inc.
 */

#include "config.h"

#include "bitmap.h"
#include "gdi.h"
#include "sdldrv.h"
#include "debugtools.h"

DEFAULT_DEBUG_CHANNEL(sdldrv);

/**********************************************************************/

extern HBITMAP SDLDRV_DC_BITMAP_SelectObject(DC *dc, HBITMAP hbitmap, BITMAPOBJ *bitmap);
extern BOOL SDLDRV_DC_BITMAP_DeleteObject(HBITMAP hbitmap, BITMAPOBJ *bitmap);


/***********************************************************************
 *		SDLDRV_DC_BRUSH_SelectObject
 */
static HBRUSH SDLDRV_DC_BRUSH_SelectObject(DC *dc, HBRUSH hbrush)
{
  HBRUSH hPreviousBrush;

  TRACE("(%p, 0x%04x)\n", dc, hbrush);

  hPreviousBrush = dc->hBrush;
  dc->hBrush = hbrush;

  return hPreviousBrush;
}

/***********************************************************************
 *		SDLDRV_DC_FONT_SelectObject
 */
static HFONT SDLDRV_DC_FONT_SelectObject(DC* dc, HFONT hfont)
{
  TRACE("(%p, 0x%04x)\n", dc, hfont);

  return TRUE; /* Use device font */
}

/***********************************************************************
 *		SDLDRV_DC_PEN_SelectObject
 */
static HPEN SDLDRV_DC_PEN_SelectObject(DC *dc, HBRUSH hpen)
{
  HPEN hPreviousPen;

  TRACE("(%p, 0x%04x)\n", dc, hpen);

  hPreviousPen = dc->hPen;
  dc->hPen = hpen;

  return hPreviousPen;
}

/***********************************************************************
 *		SDLDRV_DC_SelectObject
 */
HGDIOBJ SDLDRV_DC_SelectObject(DC *dc, HGDIOBJ handle)
{
  GDIOBJHDR *ptr = GDI_GetObjPtr(handle, MAGIC_DONTCARE);
  HGDIOBJ result = 0;

  if(!ptr) return 0;

  switch(GDIMAGIC(ptr->wMagic))
  {
    case BITMAP_MAGIC:
      result = SDLDRV_DC_BITMAP_SelectObject(dc, handle, (BITMAPOBJ *) ptr);
      break;
    case BRUSH_MAGIC:
      result = SDLDRV_DC_BRUSH_SelectObject(dc, handle);
      break;
    case FONT_MAGIC:
      result = SDLDRV_DC_FONT_SelectObject(dc, handle);
      break;
    case PEN_MAGIC:
      result = SDLDRV_DC_PEN_SelectObject(dc, handle);
      break;
    case REGION_MAGIC:
      /* FIXME: Shouldn't be handled here */
      result = (HGDIOBJ) SelectClipRgn(dc->hSelf, handle);
      break;
    default:
      ERR("handle (0x%04x) has unknown magic (0x%04x)\n",
						handle, GDIMAGIC(ptr->wMagic));
  }

  GDI_ReleaseObj(handle);
    
  return result;
}

/***********************************************************************
 *           SDLDRV_DC_DeleteObject
 */
BOOL SDLDRV_DC_DeleteObject(HGDIOBJ handle)
{
  GDIOBJHDR *ptr = GDI_GetObjPtr(handle, MAGIC_DONTCARE);
  BOOL result;
  
  if(!ptr) return FALSE;
     
  switch(GDIMAGIC(ptr->wMagic))
  {
    case BITMAP_MAGIC:
      result = SDLDRV_DC_BITMAP_DeleteObject(handle, (BITMAPOBJ *) ptr);
      break;
    case BRUSH_MAGIC:
    case FONT_MAGIC:
    case PEN_MAGIC:
    case REGION_MAGIC:
      result = TRUE;
      break;
    default:
      ERR("handle (0x%04x) has unknown magic (0x%04x)\n",
						handle, GDIMAGIC(ptr->wMagic));   
      result = FALSE;
  }

  GDI_ReleaseObj(handle);

  return result;
}
