/*
 * SDL driver definitions
 */

#ifndef __WINE_SDLDRV_H
#define __WINE_SDLDRV_H

#ifndef __WINE_CONFIG_H 
//# error You must include config.h to use this header 
#endif 

#include <SDL/SDL.h>

#include "windef.h"
#include "wingdi.h"
#include "wine/winuser16.h"
#include "wine/wingdi16.h"
#include "user.h"

struct tagBITMAPOBJ;
struct tagCLASS;
struct tagDC;
struct tagDESKTOP;
struct tagPALETTEOBJ;
struct tagWND;
struct tagCURSORICONINFO;
struct tagCREATESTRUCTA;
struct tagWINDOWPOS;


/**************************************************************************
 * SDL GDI driver
 */

extern BOOL SDLDRV_GDI_Initialize(void);

/* SDL GDI bitmap driver */

extern HBITMAP SDLDRV_BITMAP_CreateDIBSection(struct tagDC *dc, BITMAPINFO *bmi, UINT usage, LPVOID *bits, HANDLE section, DWORD offset);
extern INT SDLDRV_BITMAP_SetDIBits(struct tagBITMAPOBJ *bmp, struct tagDC *dc, UINT startscan, UINT lines, LPCVOID bits, const BITMAPINFO *info, UINT coloruse, HBITMAP hbitmap);
extern INT SDLDRV_BITMAP_GetDIBits(struct tagBITMAPOBJ *bmp, struct tagDC *dc, UINT startscan, UINT lines, LPVOID bits, BITMAPINFO *info, UINT coloruse, HBITMAP hbitmap);
extern void SDLDRV_BITMAP_DeleteDIBSection(struct tagBITMAPOBJ *bmp);
extern UINT SDLDRV_BITMAP_SetDIBColorTable(struct tagBITMAPOBJ *,struct tagDC *,UINT,UINT,const RGBQUAD *);
extern UINT SDLDRV_BITMAP_GetDIBColorTable(struct tagBITMAPOBJ *,struct tagDC *,UINT,UINT,RGBQUAD *);
extern INT SDLDRV_BITMAP_Lock(struct tagBITMAPOBJ *,INT,BOOL);
extern void SDLDRV_BITMAP_Unlock(struct tagBITMAPOBJ *,BOOL);

typedef struct { int dummy; } WINDOW;

typedef struct {
  SDL_Surface *surface;
} SDLDRV_PDEVICE;

extern BOOL SDLDRV_DC_CreateBitmap(HBITMAP hbitmap);

extern BOOL SDLDRV_DC_Arc(struct tagDC *dc, INT left, INT top, INT right, INT bottom, INT xstart, INT ystart, INT xend, INT yend);
extern LONG SDLDRV_DC_BitmapBits(HBITMAP hbitmap, void *bits, LONG count, WORD flags);
extern BOOL SDLDRV_DC_CreateBitmap(HBITMAP hbitmap);
extern BOOL SDLDRV_DC_CreateDC(struct tagDC *dc, LPCSTR driver, LPCSTR device, LPCSTR output, const DEVMODEA *initData);
extern BOOL SDLDRV_DC_DeleteDC(struct tagDC *dc);
extern BOOL SDLDRV_DC_DeleteObject(HGDIOBJ handle);
extern BOOL SDLDRV_DC_BitBlt(struct tagDC *dcDst, INT xDst, INT yDst, INT width, INT height, struct tagDC *dcSrc, INT xSrc, INT ySrc, DWORD rop);
extern BOOL SDLDRV_DC_Chord(struct tagDC *dc, INT left, INT top, INT right, INT bottom, INT xstart, INT ystart, INT xend, INT yend);
extern BOOL SDLDRV_DC_Ellipse(struct tagDC *dc, INT left, INT top, INT right, INT bottom);
extern INT SDLDRV_DC_Escape(struct tagDC *dc, INT nEscape, INT cbInput, SEGPTR lpInData, SEGPTR lpOutData);
extern BOOL SDLDRV_DC_ExtFloodFill(struct tagDC *dc, INT x, INT y, COLORREF color, UINT fillType);
extern BOOL SDLDRV_DC_ExtTextOut(struct tagDC *dc, INT x, INT y, UINT flags, const RECT *lpRect, LPCWSTR str, UINT count, const INT *lpDx);
extern BOOL SDLDRV_DC_GetCharWidth(struct tagDC *dc, UINT firstChar, UINT lastChar, LPINT buffer);
extern COLORREF SDLDRV_DC_GetPixel(struct tagDC *dc, INT x, INT y);

extern BOOL SDLDRV_DC_GetTextExtentPoint(struct tagDC *dc, LPCWSTR str, INT count, LPSIZE size);
extern BOOL SDLDRV_DC_GetTextMetrics(struct tagDC *dc, TEXTMETRICW *metrics);
extern BOOL SDLDRV_DC_LineTo(struct tagDC *dc, INT x, INT y);
extern BOOL SDLDRV_DC_PaintRgn(struct tagDC *dc, HRGN hrgn);
extern BOOL SDLDRV_DC_PatBlt(struct tagDC *dc, INT left, INT top, INT width, INT height, DWORD rop);
extern BOOL SDLDRV_DC_Pie(struct tagDC *dc, INT left, INT top, INT right, INT bottom, INT xstart, INT ystart, INT xend, INT yend);
extern BOOL SDLDRV_DC_Polygon(struct tagDC *dc, const POINT* pt, INT count);
extern BOOL SDLDRV_DC_Polyline(struct tagDC *dc, const POINT* pt, INT count);
extern BOOL SDLDRV_DC_PolyPolygon(struct tagDC *dc, const POINT* pt, const INT* counts, UINT polygons);
extern BOOL SDLDRV_DC_PolyPolyline(struct tagDC *dc, const POINT* pt, const DWORD* counts, DWORD polylines);
extern BOOL SDLDRV_DC_Rectangle(struct tagDC *dc, INT left, INT top, INT right, INT bottom);
extern BOOL SDLDRV_DC_RoundRect(struct tagDC *dc, INT left, INT top, INT right, INT bottom, INT ell_width, INT ell_height);
extern void SDLDRV_DC_SetDeviceClipping(struct tagDC *dc);
extern HGDIOBJ SDLDRV_DC_SelectObject(struct tagDC *dc, HGDIOBJ handle);
extern COLORREF SDLDRV_DC_SetBkColor(struct tagDC *dc, COLORREF color);
extern COLORREF SDLDRV_DC_SetPixel(struct tagDC *dc, INT x, INT y, COLORREF color);
extern COLORREF SDLDRV_DC_SetTextColor(struct tagDC *dc, COLORREF color);
extern BOOL SDLDRV_DC_StretchBlt(struct tagDC *dcDst, INT xDst, INT yDst, INT widthDst, INT heightDst, struct tagDC *dcSrc, INT xSrc, INT ySrc, INT widthSrc, INT heightSrc, DWORD rop);
INT SDLDRV_DC_SetDIBitsToDevice(struct tagDC *dc, INT xDest, INT yDest, DWORD cx, DWORD cy, INT xSrc, INT ySrc, UINT startscan, UINT lines, LPCVOID bits, const BITMAPINFO *info, UINT coloruse);

/* SDL GDI palette driver */

extern struct tagPALETTE_DRIVER SDLDRV_PALETTE_Driver;

extern BOOL SDLDRV_PALETTE_Initialize(void);
extern int SDLDRV_PALETTE_SetMapping(struct tagPALETTEOBJ *palPtr, UINT uStart, UINT uNum, BOOL mapOnly);
extern int SDLDRV_PALETTE_UpdateMapping(struct tagPALETTEOBJ *palPtr);
extern BOOL SDLDRV_PALETTE_IsDark(int pixel);

/**************************************************************************
 * SDL USER driver
 */

extern SDL_Surface *primary_surface;
extern const SDL_VideoInfo *video_info;

#endif /* !defined(__WINE_SDLDRV_H) */
