/*
 * SDLDRV initialization code
 */

#include "config.h"

#include <stdio.h>

#include "winbase.h"
#include "wine/winbase16.h"
#include "gdi.h"
#include "user.h"
#include "win.h"
#include "debugtools.h"
#include "sdldrv.h"

DEFAULT_DEBUG_CHANNEL(sdldrv);

SDL_Surface *primary_surface;
const SDL_VideoInfo *video_info;


/***********************************************************************
 *           SDLDRV process initialisation routine
 */
static void process_attach(void)
{
    TRACE("initializing SDL\n");
    SDL_Init(SDL_INIT_VIDEO | SDL_INIT_NOPARACHUTE);
    primary_surface = SDL_SetVideoMode(640, 480, 16, 0);
    video_info = SDL_GetVideoInfo();

    SDLDRV_GDI_Initialize();

    /* load display.dll */
    LoadLibrary16( "display" );
    TRACE("SDL initialized\n");
}


/***********************************************************************
 *           SDLDRV process termination routine
 */
static void process_detach(void)
{
    TRACE("shutting down SDL\n");
    SDL_Quit();
    TRACE("SDL shut down\n");
}


/***********************************************************************
 *           SDLDRV initialisation routine
 */
BOOL WINAPI SDLDRV_Init( HINSTANCE hinst, DWORD reason, LPVOID reserved )
{
    switch(reason)
    {
    case DLL_PROCESS_ATTACH:
        process_attach();
        break;

    case DLL_PROCESS_DETACH:
        process_detach();
        break;
    }
    return TRUE;
}
