/*
 * SDLDRV USER driver functions
 *
 * Copyright 1998 Patrik Stridvall
 * Copyright 2002 TransGaming Technologies, Inc.
 */

#include "config.h"

#include "gdi.h"
#include "dinput.h"
#include "sdldrv.h"
#include "debugtools.h"

DEFAULT_DEBUG_CHANNEL(sdldrv);


/***********************************************************************
 *		VkKeyScan (SDLDRV.@)
 */
WORD SDLDRV_VkKeyScan(CHAR cChar)
{
  return 0;
}

/***********************************************************************
 *              MapVirtualKey (SDLDRV.@)
 */
UINT16 SDLDRV_MapVirtualKey(UINT16 wCode, UINT16 wMapType)
{
  switch (wMapType) {
  case 1: /* scancode -> VK */
    TRACE("(%d,%d): stub\n", wCode, wMapType);
    switch (wCode) {
    case 0x01: return VK_ESCAPE;
    case 0x39: return VK_SPACE;
    case 0x48:
    case 0xC8: return VK_UP;
    case 0x4B:
    case 0xCB: return VK_LEFT;
    case 0x4D:
    case 0xCD: return VK_RIGHT;
    case 0x50:
    case 0xD0: return VK_DOWN;
    default:
      FIXME("unknown scancode %02x\n", wCode);
      return 0;
    }
  default:
    FIXME("(%d,%d): stub\n", wCode, wMapType);
    break;
  }
  return 0;
}

/***********************************************************************
 *		GetKeyNameText (SDLDRV.@)
 */
INT16 SDLDRV_GetKeyNameText( LONG lParam, LPSTR lpBuffer, INT16 nSize )
{  
  if(lpBuffer && nSize)
    {
      *lpBuffer = 0;
    }
  return 0;
}

/***********************************************************************
 *		ToUnicode (SDLDRV.@)
 */
INT SDLDRV_ToUnicode( UINT virtKey, UINT scanCode, LPBYTE lpKeyState,
		      LPWSTR pwszBuff, int cchBuff, UINT flags )
{
  return 0;
}

/***********************************************************************
 *		Beep (SDLDRV.@)
 */
void SDLDRV_Beep(void)
{
}

/***********************************************************************
 *		SetCursor (SDLDRV.@)
 */
void SDLDRV_SetCursor( struct tagCURSORICONINFO *lpCursor )
{
}

/***********************************************************************
 *              GetScreenSaveActive (SDLDRV.@)
 *
 * Returns the active status of the screen saver
 */
BOOL SDLDRV_GetScreenSaveActive(void)
{
    return FALSE;
}

/***********************************************************************
 *              SetScreenSaveActive (SDLDRV.@)
 *
 * Activate/Deactivate the screen saver
 */
void SDLDRV_SetScreenSaveActive(BOOL bActivate)
{
    FIXME("(%d): stub\n", bActivate);
}

/**********************************************************************
 *              LoadOEMResource (SDLDRV.@)
 */
HANDLE SDLDRV_LoadOEMResource(WORD resid, WORD type)
{
  HBITMAP hbitmap;
  switch(type)
  {
    case OEM_BITMAP:
        hbitmap = CreateBitmap(1, 1, 1, 1, NULL);
        SDLDRV_DC_CreateBitmap(hbitmap);
        return hbitmap;
    case OEM_CURSOR:
    case OEM_ICON:
        break;
    default:
      ERR("unknown type (%d)\n", type);
  }
  return 0;
}

/***********************************************************************
 *		AcquireClipboard (SDLDRV.@)
 */
void SDLDRV_AcquireClipboard(void)
{
}

/***********************************************************************
 *		ReleaseClipboard (SDLDRV.@)
 */
void SDLDRV_ReleaseClipboard(void)
{
}

/***********************************************************************
 *		SetClipboardData (SDLDRV.@)
 */
void SDLDRV_SetClipboardData(UINT wFormat)
{
}

/***********************************************************************
 *		GetClipboardData (SDLDRV.@)
 */
BOOL SDLDRV_GetClipboardData(UINT wFormat)
{
  return FALSE;
}

/***********************************************************************
 *		IsClipboardFormatAvailable (SDLDRV.@)
 */
BOOL SDLDRV_IsClipboardFormatAvailable(UINT wFormat)
{
  return FALSE;
}

/**************************************************************************
 *		RegisterClipboardFormat (SDLDRV.@)
 *
 * Registers a custom clipboard format
 * Returns: TRUE - new format registered, FALSE - Format already registered
 */
BOOL SDLDRV_RegisterClipboardFormat( LPCSTR FormatName )
{
  return TRUE;
}

/**************************************************************************
 *		IsSelectionOwner (SDLDRV.@)
 *
 * Returns: TRUE - We(WINE) own the selection, FALSE - Selection not owned by us
 */
BOOL SDLDRV_IsSelectionOwner(void)
{
  return FALSE;
}

/***********************************************************************
 *		SDLDRV_ProcessEvent
 */
void SDLDRV_ProcessEvent(SDL_Event *event)
{
  INPUT input;

  switch (event->type) {
  case SDL_KEYDOWN:
  case SDL_KEYUP:
    TRACE("keyboard (state=%d, keysym=%d)\n",
	  event->key.state, event->key.keysym.sym);
    switch (event->key.keysym.sym) {
    case SDLK_UP:
      input.u.ki.wVk = VK_UP;
      break;
    case SDLK_DOWN:
      input.u.ki.wVk = VK_DOWN;
      break;
    case SDLK_LEFT:
      input.u.ki.wVk = VK_LEFT;
      break;
    case SDLK_RIGHT:
      input.u.ki.wVk = VK_RIGHT;
      break;
    case SDLK_LSHIFT:
      input.u.ki.wVk = VK_LSHIFT;
      break;
    case SDLK_RSHIFT:
      input.u.ki.wVk = VK_RSHIFT;
      break;
    case SDLK_LCTRL:
      input.u.ki.wVk = VK_LCONTROL;
      break;
    case SDLK_RCTRL:
      input.u.ki.wVk = VK_RCONTROL;
      break;
    case SDLK_LALT:
      input.u.ki.wVk = VK_LMENU;
      break;
    case SDLK_RALT:
      input.u.ki.wVk = VK_RMENU;
      break;

    default:
      if (event->key.keysym.sym < 256) {
	input.u.ki.wVk = toupper(event->key.keysym.sym);
      }
      else {
	FIXME("unknown keysym %d\n", event->key.keysym.sym);
	input.u.ki.wVk = 0;
      }
      break;
    }
    TRACE("vk=%d\n", input.u.ki.wVk);
    input.type = WINE_INTERNAL_INPUT_KEYBOARD;
    input.u.ki.wScan = event->key.keysym.scancode;
    input.u.ki.dwFlags = (event->key.state == SDL_PRESSED) ? 0 : KEYEVENTF_KEYUP;
    input.u.ki.time = GetTickCount();
    input.u.ki.dwExtraInfo = 0;
    SendInput(1, &input, sizeof(input));
    break;
  case SDL_MOUSEMOTION:
    FIXME("mouse motion\n");
    break;
  case SDL_MOUSEBUTTONDOWN:
    FIXME("mouse button down\n");
    break;
  case SDL_MOUSEBUTTONUP:
    FIXME("mouse button up\n");
    break;
  case SDL_QUIT:
    FIXME("quit\n");
    break;
  }
}

/***********************************************************************
 *		MsgWaitForMultipleObjectsEx (SDLDRV.@)
 */
DWORD SDLDRV_MsgWaitForMultipleObjectsEx( DWORD count, const HANDLE *handles,
                                          DWORD timeout, DWORD mask, DWORD flags )
{
  SDL_Event event;

  if (SDL_PollEvent(&event)) {
    SDLDRV_ProcessEvent(&event);
    return WAIT_OBJECT_0 + count;
  }

  return WaitForMultipleObjectsEx( count, handles, flags & MWMO_WAITALL,
				   timeout, flags & MWMO_ALERTABLE );
}
