#define COBJMACROS
#include "initguid.h"

#include <windows.h>
#include <dxgi1_6.h>
#include <d3d9.h>
#include <stdio.h>
#include <SetupAPI.h>
#include "devpkey.h"
#include <devguid.h>

#define ARRAY_SIZE(x) (sizeof(x)/sizeof(x[0]))

void ByDXGI()
{
	IDXGIFactory *factory;
	IDXGIAdapter *adapter;
	IDXGIOutput *output;
	DXGI_ADAPTER_DESC adapter_desc;
	DXGI_OUTPUT_DESC output_desc;
	HRESULT hr;

	hr = CreateDXGIFactory(&IID_IDXGIFactory, (void **)&factory);
	if (FAILED(hr))
	{
		printf("CreateDXGIFactory failed\n");
		return;
	}

	for (int i = 0; (hr = IDXGIFactory_EnumAdapters(factory, i, &adapter)) == S_OK; ++i)
	{
		memset(&adapter_desc, 0, sizeof(adapter_desc));
		hr = IDXGIAdapter_GetDesc(adapter, &adapter_desc);
		if (FAILED(hr))
			printf("IDXGIAdapter_GetDesc failed\n");

		printf("#%d:\n", i);
		wprintf(L"Description: %s\n", adapter_desc.Description);
		printf("VendorId: 0x%04x\n", adapter_desc.VendorId);
		printf("DeviceId: 0x%04x\n", adapter_desc.DeviceId);
		printf("SubSysId: 0x%08x\n", adapter_desc.SubSysId);
		printf("Revision: 0x%04x\n", adapter_desc.Revision);
		printf("DedicatedVideoMemory: %dMB\n", adapter_desc.DedicatedVideoMemory/1024/1024);
		printf("DedicatedSystemMemory: %dMB\n", adapter_desc.DedicatedSystemMemory / 1024 / 1024);
		printf("SharedSystemMemory: %dMB\n", adapter_desc.SharedSystemMemory / 1024 / 1024);
		printf("AdapterLuid: 0x%08x:0x%08x\n\n", adapter_desc.AdapterLuid.HighPart, adapter_desc.AdapterLuid.LowPart);

		//Sleep(15 * 1000);
		//for (int j = 0; (hr = IDXGIAdapter_EnumOutputs(adapter, j, &output)) == S_OK; ++j)
		//{
		//	memset(&output_desc, 0, sizeof(output_desc));
		//	hr = IDXGIOutput_GetDesc(output, &output_desc);
		//	if (FAILED(hr))
		//		printf("IDXGIAdapter_GetDesc failed\n");

		//	printf("\t#%d:\n", j);
		//	wprintf(L"\tDeviceName: %s\n", output_desc.DeviceName);
		//	printf("\tDesktopCoordinates: (%d,%d,%d,%d)\n", output_desc.DesktopCoordinates.left, output_desc.DesktopCoordinates.top, output_desc.DesktopCoordinates.right, output_desc.DesktopCoordinates.bottom);
		//	printf("\tAttachedToDesktop: 0x%08x\n", output_desc.AttachedToDesktop);
		//	printf("\tRotation: 0x%08x\n", output_desc.Rotation);
		//	printf("\tMonitor: 0x%08x\n\n", output_desc.Monitor);
		//	IDXGIOutput_Release(output);
		//}

		//Sleep(15 * 1000);
		for (int j = 0; (hr = IDXGIAdapter_EnumOutputs(adapter, j, &output)) == S_OK; ++j)
		{
			memset(&output_desc, 0, sizeof(output_desc));
			hr = IDXGIOutput_GetDesc(output, &output_desc);
			if (FAILED(hr))
				printf("IDXGIAdapter_GetDesc failed\n");

			printf("\t#%d:\n", j);
			wprintf(L"\tDeviceName: %s\n", output_desc.DeviceName);
			printf("\tDesktopCoordinates: (%d,%d,%d,%d)\n", output_desc.DesktopCoordinates.left, output_desc.DesktopCoordinates.top, output_desc.DesktopCoordinates.right, output_desc.DesktopCoordinates.bottom);
			printf("\tAttachedToDesktop: 0x%08x\n", output_desc.AttachedToDesktop);
			printf("\tRotation: 0x%08x\n", output_desc.Rotation);
			printf("\tMonitor: 0x%08x\n\n", output_desc.Monitor);

			UINT mode_count = 0;
			hr = IDXGIOutput_GetDisplayModeList(output, DXGI_FORMAT_R8G8B8A8_UNORM, 0, &mode_count, NULL);
			if (hr != S_OK)
			{
				printf("IDXGIOutput_GetDisplayModeList failed\n");
				IDXGIOutput_Release(output);
				break;
			}

			DXGI_MODE_DESC* modes;
			printf("\tmode_count %d\n", mode_count);
			if (!(modes = calloc(mode_count, sizeof(*modes))))
			{
				printf("calloc failed\n");
				IDXGIOutput_Release(output);
				break;
			}

			hr = IDXGIOutput_GetDisplayModeList(output, DXGI_FORMAT_R8G8B8A8_UNORM, 0, &mode_count, modes);
			if (hr != S_OK)
			{
				printf("IDXGIOutput_GetDisplayModeList failed\n");
				free(modes);
				IDXGIOutput_Release(output);
				break;
			}
			for (UINT k = 0; k < mode_count; ++k)
			{
				printf("\t\t%ux%u@%uHz\n", modes[k].Width, modes[k].Height, modes[k].RefreshRate.Numerator/ modes[k].RefreshRate.Denominator);
			}
			
			free(modes);
			IDXGIOutput_Release(output);
		}

		IDXGIAdapter_Release(adapter);
	}

	IDXGIFactory_Release(factory);
}

struct state_flag_pair
{
	const CHAR * name;
	DWORD value;
};

void PrintDisplayDeviceStateFlags(DWORD flags, BOOL is_child)
{
	static const struct state_flag_pair state_flag_pairs[] =
	{ { "DISPLAY_DEVICE_ATTACHED_TO_DESKTOP",0x00000001},
	{   "DISPLAY_DEVICE_MULTI_DRIVER",0x00000002},
	{	"DISPLAY_DEVICE_PRIMARY_DEVICE",0x00000004},
	{	"DISPLAY_DEVICE_MIRRORING_DRIVER",0x00000008},
	{	"DISPLAY_DEVICE_VGA_COMPATIBLE",0x00000010},
	{	"DISPLAY_DEVICE_REMOVABLE",0x00000020},
	{	"DISPLAY_DEVICE_ACC_DRIVER",0x00000040},
	{	"DISPLAY_DEVICE_MODESPRUNED",0x08000000},
	{	"DISPLAY_DEVICE_RDPUDD",0x01000000},
	{	"DISPLAY_DEVICE_REMOTE",0x04000000},
	{	"DISPLAY_DEVICE_DISCONNECT",0x02000000},
	{	"DISPLAY_DEVICE_TS_COMPATIBLE",0x00200000},
	{	"DISPLAY_DEVICE_UNSAFE_MODES_ON",0x00080000}
	};

	static const struct state_flag_pair child_state_flag_pairs[] =
	{ { "DISPLAY_DEVICE_ACTIVE",0x00000001},
	{   "DISPLAY_DEVICE_ATTACHED",0x00000002},
	{	"DISPLAY_DEVICE_PRIMARY_DEVICE",0x00000004},
	{	"DISPLAY_DEVICE_MIRRORING_DRIVER",0x00000008},
	{	"DISPLAY_DEVICE_VGA_COMPATIBLE",0x00000010},
	{	"DISPLAY_DEVICE_REMOVABLE",0x00000020},
	{	"DISPLAY_DEVICE_ACC_DRIVER",0x00000040},
	{	"DISPLAY_DEVICE_MODESPRUNED",0x08000000},
	{	"DISPLAY_DEVICE_RDPUDD",0x01000000},
	{	"DISPLAY_DEVICE_REMOTE",0x04000000},
	{	"DISPLAY_DEVICE_DISCONNECT",0x02000000},
	{	"DISPLAY_DEVICE_TS_COMPATIBLE",0x00200000},
	{	"DISPLAY_DEVICE_UNSAFE_MODES_ON",0x00080000}
	};

	const struct state_flag_pair  *pairs = is_child ? child_state_flag_pairs : state_flag_pairs;

	for (int i = 0; i < ARRAY_SIZE(state_flag_pairs); i++)
	{
		if (pairs[i].value & flags)
			printf("%s ", pairs[i].name);
	}
}

void PrintDisplayDevice(const DISPLAY_DEVICEA *device, BOOL is_child)
{
	if (is_child) putchar('\t'); 
	printf("DeviceName: %s\n", device->DeviceName);
	if (is_child) putchar('\t');
	printf("DeviceString: %s\n", device->DeviceString);
	if (is_child) putchar('\t');
	printf("StateFlags: %#x ", device->StateFlags);
	PrintDisplayDeviceStateFlags(device->StateFlags, is_child);
	printf("\n");
	if (is_child) putchar('\t');
	printf("DeviceID: %s\n", device->DeviceID);
	if (is_child) putchar('\t');
	printf("DeviceKey: %s\n", device->DeviceKey);
}

void ByEnumDisplayDevices(DWORD flags)
{
	BOOL ret = TRUE;
	DISPLAY_DEVICEA display_device = { sizeof(display_device) };

	for (int i = 0; EnumDisplayDevicesA(NULL, i, &display_device, flags); i++)
	{
		CHAR device_name[32];
		memcpy(device_name, display_device.DeviceName, sizeof(display_device.DeviceName));
		
		printf("#%d\n", i);
		PrintDisplayDevice(&display_device, FALSE);
		printf("\n");
		memset(&display_device, 0, sizeof(display_device));
		display_device.cb = sizeof(display_device);

		for (int j = 0; EnumDisplayDevicesA(device_name, j, &display_device, flags); j++)
		{
			printf("\t#%d\n", j);
			PrintDisplayDevice(&display_device, TRUE);
			printf("\n");
			memset(&display_device, 0, sizeof(display_device));
			display_device.cb = sizeof(display_device);
		}
	}
}

BOOL
WINAPI MonitorEnumProc(
	HMONITOR monitor,
	HDC hdc,
	LPRECT rect,
	LPARAM lparam
)
{
	MONITORINFOEXW monitor_info;
	BOOL ret;
	printf("hmonitor %#x, rect %d %d %d %d\n", monitor, rect->left ,rect->top, rect->right, rect->bottom);
     monitor_info.cbSize = sizeof(monitor_info) + 1;
	ret = GetMonitorInfoW(monitor, &monitor_info);
	if (ret)
	{
		printf(" rect:%d %d %d %d work rect:%d %d %d %d dwFlags:%#x\n",  monitor_info.rcMonitor.left, monitor_info.rcMonitor.top, monitor_info.rcMonitor.right, monitor_info.rcMonitor.bottom,
																																										        monitor_info.rcWork.left, monitor_info.rcWork.top, monitor_info.rcWork.right, monitor_info.rcWork.bottom, monitor_info.dwFlags);
	}
	else
	{
		printf("GetMonitorInfoW failed\n");
	}

	//if (!strcmp(monitor_info.szDevice, "\\\\.\\DISPLAY2"))
	//{
	//	printf("Sleep 10s\n");

	//	ret = GetMonitorInfoA(monitor, &monitor_info);
	//	if (ret)
	//	{
	//		printf("name:%s rect:%d %d %d %d work rect:%d %d %d %d dwFlags:%#x\n", monitor_info.szDevice, monitor_info.rcMonitor.left, monitor_info.rcMonitor.top, monitor_info.rcMonitor.right, monitor_info.rcMonitor.bottom,
	//			monitor_info.rcWork.left, monitor_info.rcWork.top, monitor_info.rcWork.right, monitor_info.rcWork.bottom, monitor_info.dwFlags);
	//	}
	//	else
	//	{
	//		printf("GetMonitorInfoW failed\n");
	//	}
	//}
	return TRUE;
}

static void ByEnumDisplayMonitors(void)
{
	BOOL ret;
	ret = EnumDisplayMonitors(NULL, NULL, MonitorEnumProc, NULL);
	if(!ret)
		printf("EnumDisplayMonitors failed\n");
}

static void PrintDevModeA(const DEVMODEA* dev_mode)
{
	//printf("dmSize:%d\n", sizeof(DEVMODEA));
	printf("dmBitsPerPel:%d\n", dev_mode->dmBitsPerPel);
	printf("dmPelsWidth:%d\n", dev_mode->dmPelsWidth);
	printf("dmPelsHeight:%d\n", dev_mode->dmPelsHeight);
	//printf("dmDisplayFlags:%d\n", dev_mode->dmDisplayFlags);
	printf("dmDisplayFrequency:%d\n", dev_mode->dmDisplayFrequency);
	//printf("dmPosition:(%d,%d)\n", dev_mode->dmPosition.x, dev_mode->dmPosition.y);
	printf("dmDisplayOrientation:%d\n", dev_mode->dmDisplayOrientation);
}


static void ByEnumDisplaySettings(void)
{
	DISPLAY_DEVICEA display_device = { sizeof(display_device) };
	DEVMODEA dev_mode = {.dmSize = sizeof(dev_mode)};
	INT number;

	for (int i = 0; EnumDisplayDevicesA(NULL, i, &display_device, 0); i++)
	{
		if (sscanf_s(display_device.DeviceName, "\\\\.\\DISPLAY%d", &number) != 1)
			continue;

		printf("%s\n", display_device.DeviceName);
		for (int j = 0; EnumDisplaySettingsExA(display_device.DeviceName, j, &dev_mode, EDS_ROTATEDMODE); j++)
		{
			PrintDevModeA(&dev_mode);
		}
		printf("\n");
	}
	//BOOL ret = EnumDisplaySettingsA("\\\\.\\DISPLAY1", ENUM_REGISTRY_SETTINGS, &dev_mode);
	//printf("ret %#x error:%#x", ret, GetLastError());
}

static void ByD3D9(void)
{
	IDirect3D9 *d3d9;
	UINT adapter_count;
	D3DCAPS9 caps;

	if (!(d3d9 = Direct3DCreate9(D3D_SDK_VERSION)))
	{
		printf("Failed to create d3d9.\n");
	}

	adapter_count = IDirect3D9_GetAdapterCount(d3d9);
	printf("adapter count:%d\n", adapter_count);

	//Sleep(10*1000);

	//adapter_count = IDirect3D9_GetAdapterCount(d3d9);
	//printf("adapter count:%d\n", adapter_count);

	for (int i = 0; i < adapter_count; ++i)
	{
		printf("monitor:%p.\n", IDirect3D9_GetAdapterMonitor(d3d9, i));
		IDirect3D9_GetDeviceCaps(d3d9, i, D3DDEVTYPE_HAL, &caps);
		printf("AdapterOrdinal:%d\n", caps.AdapterOrdinal);
	}
}

DEFINE_DEVPROPKEY(DEVPROPKEY_GPU_LUID, 0x60b193cb, 0x5276, 0x4d0f, 0x96, 0xfc, 0xf1, 0x73, 0xab, 0xad, 0x3e, 0xc6, 2);
DEFINE_DEVPROPKEY(DEVPROPKEY_MONITOR_GPU_LUID, 0xca085853, 0x16ce, 0x48aa, 0xb1, 0x14, 0xde, 0x9c, 0x72, 0x33, 0x42, 0x23, 1);
DEFINE_DEVPROPKEY(DEVPROPKEY_MONITOR_OUTPUT_ID, 0xca085853, 0x16ce, 0x48aa, 0xb1, 0x14, 0xde, 0x9c, 0x72, 0x33, 0x42, 0x23, 2);

static void BySetupAPI(void)
{
	HDEVINFO devinfo;
	SP_DEVINFO_DATA device_data = { sizeof(device_data) };
	DWORD type;
	DWORD i = 0;
	LUID luid;
	INT id;
	BOOL present;

	printf("GPU:\n");
	devinfo = SetupDiGetClassDevsW(&GUID_DEVCLASS_DISPLAY, L"PCI", NULL, 0);
	while (SetupDiEnumDeviceInfo(devinfo, i++, &device_data))
	{
		present = FALSE;
		if(!SetupDiGetDevicePropertyW(devinfo, &device_data, &DEVPKEY_Device_IsPresent, &type, (BYTE*)&present,
			sizeof(present), NULL, 0))
		{
			printf("%d SetupDiGetDevicePropertyW failed, error %#x\n", i, GetLastError());
		}
		if (!present)
			continue;

		if (!SetupDiGetDevicePropertyW(devinfo, &device_data, &DEVPROPKEY_GPU_LUID, &type, (BYTE*)&luid,
			sizeof(luid), NULL, 0))
		{
			printf("%d SetupDiGetDevicePropertyW failed, error %#x\n", i, GetLastError());
		}
		printf("Luid: 0x%08x:0x%08x type:%#x\n", luid.HighPart, luid.LowPart, type);
	}
	SetupDiDestroyDeviceInfoList(devinfo);

	printf("Monitor:\n");
	devinfo = SetupDiGetClassDevsW(&GUID_DEVCLASS_MONITOR, L"DISPLAY", NULL, 0);
	i = 0;
	while (SetupDiEnumDeviceInfo(devinfo, i++, &device_data))
	{
		present = FALSE;
		if (!SetupDiGetDevicePropertyW(devinfo, &device_data, &DEVPKEY_Device_IsPresent, &type, (BYTE*)&present,
			sizeof(present), NULL, 0))
		{
			printf("%d SetupDiGetDevicePropertyW failed, error %#x\n", i, GetLastError());
		}
		if (!present)
			continue;

		if (!SetupDiGetDevicePropertyW(devinfo, &device_data, &DEVPROPKEY_MONITOR_GPU_LUID, &type, (BYTE*)&luid,
			sizeof(luid), NULL, 0))
		{
			printf("%d SetupDiGetDevicePropertyW failed, error %#x\n", i, GetLastError());
		}
		printf("Luid: 0x%08x:0x%08x type:%#x\n", luid.HighPart, luid.LowPart, type);

		if (!SetupDiGetDevicePropertyW(devinfo, &device_data, &DEVPROPKEY_MONITOR_OUTPUT_ID, &type, (BYTE*)&id,
			sizeof(id), NULL, 0))
		{
			printf("%d SetupDiGetDevicePropertyW failed, error %#x\n", i, GetLastError());
		}
		printf("id: 0x%08x type:%#x \n", id, type);
	}
	SetupDiDestroyDeviceInfoList(devinfo);
}

//static  void ByD3DKMT(void)
//{
//	BOOL ret = TRUE;
//	DISPLAY_DEVICEW display_device = { sizeof(display_device) };
//	D3DKMT_OPENADAPTERFROMGDIDISPLAYNAME open_desc;
//	D3DKMT_CLOSEADAPTER close_desc;
//	NTSTATUS ns;
//
//	for (int i = 0; EnumDisplayDevicesW(NULL, i, &display_device, 0); i++)
//	{
//		if (!(display_device.StateFlags & DISPLAY_DEVICE_ATTACHED_TO_DESKTOP))
//			continue;
//
//		lstrcpyW(open_desc.DeviceName, display_device.DeviceName);
//		ns = D3DKMTOpenAdapterFromGdiDisplayName(&open_desc);
//		if (ns != 0)
//			printf("%d D3DKMTOpenAdapterFromGdiDisplayName failed, error %#x\n", i, ns);
//		printf("Luid: 0x%08x:0x%08x  vidsourceid %d\n", open_desc.AdapterLuid.HighPart, open_desc.AdapterLuid.LowPart, open_desc.VidPnSourceId);
//		close_desc.hAdapter = open_desc.hAdapter;
//		D3DKMTCloseAdapter(&close_desc);
//	}
//}

static void ByGetSystemMetrics(void)
{
    printf("monitor count: %d primary: %dx%d virtual: %d, %d, %d, %d\n",
            GetSystemMetrics(SM_CMONITORS), GetSystemMetrics(SM_CXSCREEN),
            GetSystemMetrics(SM_CYSCREEN), GetSystemMetrics(SM_XVIRTUALSCREEN),
            GetSystemMetrics(SM_YVIRTUALSCREEN),
            GetSystemMetrics(SM_XVIRTUALSCREEN) + GetSystemMetrics(SM_CXVIRTUALSCREEN),
            GetSystemMetrics(SM_YVIRTUALSCREEN) + GetSystemMetrics(SM_CYVIRTUALSCREEN));
}

int main()
{
	//printf("By DXGI\n");
	//ByDXGI();
    //printf("By EnumDisplayDevices flags: 0\n");
	ByEnumDisplayDevices(0);
	//printf("ByEnumDisplayDevices flags: EDD_GET_DEVICE_INTERFACE_NAME\n");
	//ByEnumDisplayDevices(1);
	//printf("By D3D9");
	//ByD3D9();
	//printf("By EnumDisplayMonitors \n");
    //ByEnumDisplayMonitors();
    //printf("By EnumDisplaySettings \n");
    //ByEnumDisplaySettings();
    //printf("By GetSystemMetrics \n");
    //ByGetSystemMetrics();

	//printf("By SetupAPI\n");
	//BySetupAPI();

	//printf("By D3DKMT\n");
	//ByD3DKMT();

	system("pause");
	return 0;
}